Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Pod/Usage.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%global cpan_name Directory-Queue

Name:           perl-%{cpan_name}
Version:        2.2
Release:        alt1_11
Summary:        Object oriented interface to a directory based queue
License:        GPL-1.0-or-later OR Artistic-1.0-Perl
URL:            https://metacpan.org/release/%{cpan_name}
Source0:        https://cpan.metacpan.org/authors/id/L/LC/LCONS/%{cpan_name}-%{version}.tar.gz
BuildArch:      noarch
BuildRequires:  coreutils
BuildRequires:  rpm-build-perl
BuildRequires:  perl-devel
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(warnings.pm)
# Run-time
BuildRequires:  perl(constant.pm)
BuildRequires:  perl(Encode.pm)
BuildRequires:  perl(No/Worries/Die.pm)
BuildRequires:  perl(No/Worries/Export.pm)
BuildRequires:  perl(No/Worries/File.pm)
BuildRequires:  perl(No/Worries/Stat.pm)
BuildRequires:  perl(No/Worries/Warn.pm)
BuildRequires:  perl(POSIX.pm)
BuildRequires:  perl(Time/HiRes.pm)
# Tests
BuildRequires:  perl(File/Temp.pm)
BuildRequires:  perl(No/Worries/Dir.pm)
BuildRequires:  perl(Test/More.pm)
# Optional tests
BuildRequires:  perl(Pod/Coverage.pm)
BuildRequires:  perl(Test/Pod.pm)
BuildRequires:  perl(Test/Pod/Coverage.pm)
Requires:       perl(No/Worries/Die.pm) >= 1.400

# Remove under-specified dependencies

Source44: import.info
%filter_from_requires /^perl(No.Worries.Die.pm)/d

%description
The goal of this module is to offer a simple queue system using the underlying
file system for storage, security and to prevent race conditions via atomic
operations. It focuses on simplicity, robustness and scalability.

%package tests
Group: Development/Other
Summary:        Tests for %{name}
Requires:       %{name} = %{?epoch:%{epoch}:}%{version}-%{release}

%description tests
Tests from %{name}. Execute them
with "%{_libexecdir}/%{name}/test".

%prep
%setup -q -n %{cpan_name}-%{version}

%build
perl Makefile.PL INSTALLDIRS=vendor NO_PACKLIST=1 NO_PERLLOCAL=1
%{make_build}

%install
%{makeinstall_std}
# %{_fixperms} %{buildroot}/*
# Install tests
mkdir -p %{buildroot}%{_libexecdir}/%{name}
cp -a t %{buildroot}%{_libexecdir}/%{name}
rm %{buildroot}%{_libexecdir}/%{name}/t/{3pod,4podcov}.t
cat > %{buildroot}%{_libexecdir}/%{name}/test << 'EOF'
#!/bin/sh
cd %{_libexecdir}/%{name} && exec prove -I . -j "$(getconf _NPROCESSORS_ONLN)"
EOF
chmod +x %{buildroot}%{_libexecdir}/%{name}/test

%check
export HARNESS_OPTIONS=j$(perl -e 'if ($ARGV[0] =~ /.*-j([0-9][0-9]*).*/) {print $1} else {print 1}' -- '%{?_smp_mflags}')
make test

%files
%doc Changes README
%dir %{perl_vendor_privlib}/Directory
%{perl_vendor_privlib}/Directory/Queue
%{perl_vendor_privlib}/Directory/Queue.pm

%files tests
%{_libexecdir}/%{name}

%changelog
