# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Path/Tiny.pm) perl(lib.pm)
# END SourceDeps(oneline)
%define module_version 0.006
%define module_name Dist-HomeDir
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.006
Release: alt1
Summary: easily find the distribution home directory for code never intended to be installed via a package m...
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/Z/ZA/ZARQUON/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
This module was inspired by Catalyst::Utils->home() to obtain the root
directory for obtaining application code and self-contained support data in
directories relative to the distribution root.  It does this by returning a
the Path::Tiny manpage object which has a very nice interface.  However
Catalyst::Utils->home only works for perl classes.  This works for class
files and perl scripts via examining `(caller)[1]' and thus should
never be used in code that will be instaled via a cpan client or other
package manager.

Sometimes support libaries will also live in the `t/lib' directory and the
`script/lib' directory.  `dist_home' will ignore these `lib' directories
as part of finding the distribution root.  Future versions of this module
may make the list of what directories to ignore other `lib' sub directories
user-configurable (patches welcome).

If you want to modify `@INC' with the import syntax in the second example
<<<<<<< HEAD
in the summary, be careful.  In particular if you use the Dist::HomeDir manpage in
test files and in code to be used in production, `@INC' might be modified
in unexpeted ways depending on the structure of your codebase.  The best
thing to do here is only use the import syntax in test files or maybe other
support files (e.g. in `script'), and never in code in the main package
hierarchy.
%prep
%setup -q -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README LICENSE
%perl_vendor_privlib/D*

%changelog
