%define module_name Dist-Zilla-Plugin-Alt
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Config.pm) perl(Dist/Zilla.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(File/chdir.pm) perl(List/Util.pm) perl(Moose.pm) perl(Test/DZil.pm) perl(Test2/V0.pm) perl(experimental.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.08
Release: alt1
Summary: Create Alt distributions with Dist::Zilla
Group: Development/Perl
License: perl
URL: https://metacpan.org/pod/Dist::Zilla::Plugin::Alt

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PL/PLICEASE/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This the Dist::Zilla manpage plugin can be added to an existing dist.ini file to
turn your (or someone else's distribution into an the Alt manpage distribution).
What it does is:

=over 4

=item Modifies `Makefile.PL' or `Build.PL'

Adds code to change the install location so that your dist won't
be installed unless the environment variable `PERL_ALT_INSTALL'
is set.

=item Updates the no_index meta

So that only `.pm' files in your lib directory that are in the
`Alt::' namespace will be indexed.

=item Sets the dist name property

If it isn't already specified in your `dist.ini' file.  It will
determine this from the `Alt::' module in your distribution.
If you have more than one `Alt::' module it is an error.

=back

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc author.yml Changes README LICENSE
%perl_vendor_privlib/D*

%changelog
