# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Dist-Zilla-Plugin-AppendExternalData
%define upstream_version 0.003

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt3_10

Summary:    Append data to gathered files
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/Dist/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(Dist/Zilla/Role/FileFinderUser.pm)
BuildRequires: perl(Dist/Zilla/Role/FileMunger.pm)
BuildRequires: perl(Dist/Zilla/Role/FilePruner.pm)
BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(File/Find.pm)
BuildRequires: perl(File/Temp.pm)
BuildRequires: perl(Moose.pm)
BuildRequires: perl(Moose/Autobox.pm)
BuildRequires: perl(MooseX/Types/Path/Class.pm)
BuildRequires: perl(Path/Class.pm)
BuildRequires: perl(Test/More.pm)
BuildRequires: perl(namespace/autoclean.pm)
BuildRequires: perl(strict.pm)
BuildRequires: perl(warnings.pm)
BuildArch:  noarch
Source44: import.info

%description
This the Dist::Zilla manpage plugin appends files in a directory to files
being gathered for the distribution.

When using this plugin, be thoughtful about the order in which you want
files to be modified. For example, if you are appending Pod, it makes a big
difference if you append before or after a plugin like C<PodWeaver>. If you
list this plugin first, the Pod will be appended before weaving and the
added Pod will wind up in the middle of the generated Pod. If this plugin
is listed last, the Pod will be appended after weaving and will follow the
generald Pod from C<PodWeaver>.

If appending a C<__DATA__> section, be sure to put this plugin last among
plugins that modify your files.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%make_build

%check
%make_build test

%install
%makeinstall_std

%files
%doc Changes LICENSE META.json META.yml  README
%perl_vendor_privlib/*

%changelog
