# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Moose.pm) perl(Pod/Coverage/TrustPod.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Dist-Zilla-Plugin-AssertOS
%define upstream_version 0.08

%{?perl_default_filter}

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt1_5

Summary:    Require that our distribution is running on a particular OS
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/Dist/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(Data/Compare.pm)
BuildRequires: perl(Devel/CheckOS.pm)
BuildRequires: perl(Dist/Zilla.pm)
BuildRequires: perl(Dist/Zilla/Role/MetaProvider.pm)
BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildArch:  noarch
Source44: import.info

%description
Dist::Zilla::Plugin::AssertOS is a Dist::Zilla plugin that
integrates Devel::AssertOS so that CPAN authors may easily
stipulate which particular OS environments their distributions may be built
and installed on.

The author specifies which OS or OS families are supported. The necessary
Devel::AssertOS files are copied to the 'inc/' directory and
'Makefile.PL' is mangled to include the necessary incantation.

On the module user side, the bundled 'inc/' Devel::AssertOS
determines whether the current environment is supported or not and will die
accordingly.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%make_build

%check
%make_build test

%install
%makeinstall_std

%files
%doc Changes LICENSE META.json META.yml README
%{perl_vendor_privlib}/*


%changelog
