# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Dist-Zilla-Plugin-Authority
%define upstream_version 1.009

%{?perl_default_filter}

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt1_6

Summary:    Add the $AUTHORITY variable and metadata to your distribution
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/Dist/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(Dist/Zilla/Role/FileFinderUser.pm)
BuildRequires: perl(Dist/Zilla/Role/FileMunger.pm)
BuildRequires: perl(Dist/Zilla/Role/MetaProvider.pm)
BuildRequires: perl(Dist/Zilla/Role/PPI.pm)
BuildRequires: perl(Dist/Zilla/Util.pm)
BuildRequires: perl(File/Find.pm)
BuildRequires: perl(File/HomeDir.pm)
BuildRequires: perl(File/Spec.pm)
BuildRequires: perl(File/Temp.pm)
BuildRequires: perl(Module/Build.pm)
BuildRequires: perl(Moose.pm)
BuildRequires: perl(Moose/Util/TypeConstraints.pm)
BuildRequires: perl(PPI.pm)
BuildRequires: perl(Test/More.pm)
BuildRequires: perl(strict.pm)
BuildRequires: perl(warnings.pm)
BuildArch:  noarch
Source44: import.info

%description
This plugin adds the authority data to your distribution. It adds the data
to your modules and metadata. Normally it looks for the PAUSE author id in
your the Dist::Zilla manpage configuration. If you want to override it,
please use the 'authority' attribute.

	# In your dist.ini:
	[Authority]

This code will be added to any package declarations in your perl files:

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%make_build

%check
%make_build test

%install
%makeinstall_std

%files
%doc Changes INSTALL LICENSE META.json META.yml  README SIGNATURE examples
%perl_vendor_privlib/*

%changelog
