# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Dist-Zilla-Plugin-BumpVersionFromGit
%define upstream_version 0.010

%{?perl_default_filter}

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt1_6

Summary:    Provide a version number by bumping the last git release tag
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/Dist/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(Dist/Zilla.pm)
BuildRequires: perl(Dist/Zilla/Role/VersionProvider.pm)
BuildRequires: perl(Dist/Zilla/Tester.pm)
BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(File/Copy/Recursive.pm)
BuildRequires: perl(File/Find.pm)
BuildRequires: perl(File/Temp.pm)
BuildRequires: perl(File/pushd.pm)
BuildRequires: perl(Git/Wrapper.pm)
BuildRequires: perl(Moose.pm)
BuildRequires: perl(Path/Class.pm)
BuildRequires: perl(Test/More.pm)
BuildRequires: perl(Version/Next.pm)
BuildRequires: perl(namespace/autoclean.pm)
BuildRequires: perl(version.pm)
BuildArch:  noarch
Source44: import.info

%description
This does the the Dist::Zilla::Role::VersionProvider manpage role. It finds
the last version number from tags and increments it as the new version used
by Dist::Zilla.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor
%make_build

%install
%makeinstall_std

%check
git config --global user.email "you@example.com"
git config --global user.name "Your Name"
%__make test

%files
%doc Changes LICENSE META.json META.yml README
%perl_vendor_privlib/*


%changelog
