# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Moose.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Dist-Zilla-Plugin-CopyReadmeFromBuild
%define upstream_version 0.0019

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt3_10

Summary:    Copy README after building (for SCM inclusion, etc.)
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/Dist/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(Dist/Zilla.pm)
BuildRequires: perl(Test/Most.pm)
BuildArch: noarch
Source44: import.info

%description
CopyReadmeFromBuild will automatically copy the README from the build
directory into the distribution directory. This is so you can commit the
README to version control. GitHub, for example, likes to see a README

Dist::Zilla::Plugin::Readme will not like it if you already have a README,
so you'll have to disable that plugin, an example of which is:

    [@Filter]
    bundle = @Basic
    remove = Readme

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%make_build

%check
%make_build test

%install
%makeinstall_std

%files
%doc README META.yml
%perl_vendor_privlib/*




%changelog
