# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Data/Dumper.pm) perl(List/Util.pm) perl(Module/Build.pm) perl(Module/CoreList.pm) perl(Module/Metadata.pm) perl(Path/Tiny.pm) perl(Test/Deep.pm) perl(if.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Dist-Zilla-Plugin-DualLife
%define upstream_version 0.07

%{?perl_default_filter}

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt1_5

Summary:    Distribute dual-life modules with Dist::Zilla
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/Dist/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(Dist/Zilla/Role/InstallTool.pm)
BuildRequires: perl(Dist/Zilla/Role/ModuleMetadata.pm)
BuildRequires: perl(List/AllUtils.pm)
BuildRequires: perl(Moose.pm)
BuildRequires: perl(Test/Fatal.pm)
BuildRequires: perl(Test/More.pm)
BuildRequires: perl(Test/Needs.pm)
BuildRequires: perl(namespace/autoclean.pm)
BuildArch: noarch
Source44: import.info

%description
Dual-life modules, which are modules distributed both as part of the perl
core and on CPAN, sometimes need a little special treatment. This module
tries provide that for modules built with 'Dist::Zilla'.

Currently the only thing this module does is providing an 'INSTALLDIRS'
option to 'ExtUtils::MakeMaker''s 'WriteMakefile' function, so dual-life
modules will be installed in the right section of '@INC' depending on
different versions of perl.

As more things that need special handling for dual-life modules show up,
this module will try to address them as well.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%make_build

%check
%make_build test

%install
%makeinstall_std

%files
%doc README Changes LICENCE META.yml META.json
%{perl_vendor_privlib}/*




%changelog
