# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Dist-Zilla-Plugin-Git-DescribeVersion
%define upstream_version 1.004

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt3_11

Summary:    Provide version using git-describe
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/Dist/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(Dist/Zilla.pm)
BuildRequires: perl(Dist/Zilla/Role/VersionProvider.pm)
BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(File/Find.pm)
BuildRequires: perl(File/Spec/Functions.pm)
BuildRequires: perl(File/Temp.pm)
BuildRequires: perl(Git/DescribeVersion.pm)
BuildRequires: perl(List/Util.pm)
BuildRequires: perl(Moose.pm)
BuildRequires: perl(Test/MockObject.pm)
BuildRequires: perl(Test/MockObject/Extends.pm)
BuildRequires: perl(Test/More.pm)
BuildRequires: perl(strict.pm)
BuildRequires: perl(warnings.pm)
BuildArch:  noarch
Source44: import.info

%description
This does the the Dist::Zilla::Role::VersionProvider manpage role. It uses
the Git::DescribeVersion manpage to count the number of commits since the
last tag (matching _match_pattern_) or since the initial commit, and uses
the result as the _version_ parameter for your distribution.

The plugin accepts the same options as Git::DescribeVersion/new. See the
Git::DescribeVersion/OPTIONS manpage.

You can also set the 'V' environment variable to override the new version.
This is useful if you need to bump to a specific version. For example, if
the last tag is 0.005 and you want to jump to 1.000 you can set V = 1.000.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%make_build

%install
%makeinstall_std

%check
%__make test

%files
%doc Changes LICENSE META.json META.yml  README examples
%perl_vendor_privlib/*


%changelog
