# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Module/Build.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Dist-Zilla-Plugin-GitHub
%define upstream_version 0.49

%{?perl_default_filter}

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt1_1

Summary:    Update GitHub repo info on release
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/Dist/%{upstream_name}-%{upstream_version}.tar.gz

BuildConflicts: cpanminus

BuildRequires: perl(Class/Load.pm)
BuildRequires: perl(Data/Dumper.pm)
BuildRequires: perl(Dist/Zilla/App.pm)
BuildRequires: perl(Dist/Zilla/Dist/Minter.pm)
BuildRequires: perl(Dist/Zilla/Role/AfterMint.pm)
BuildRequires: perl(Dist/Zilla/Role/AfterRelease.pm)
BuildRequires: perl(Dist/Zilla/Role/MetaProvider.pm)
BuildRequires: perl(Dist/Zilla/Role/PluginBundle/Easy.pm)
BuildRequires: perl(Dist/Zilla/Role/TextTemplate.pm)
BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(File/Basename.pm)
BuildRequires: perl(File/Spec.pm)
BuildRequires: perl(Git/Wrapper.pm)
BuildRequires: perl(HTTP/Tiny.pm)
BuildRequires: perl(IO/Socket/SSL.pm)
BuildRequires: perl(JSON/MaybeXS.pm)
BuildRequires: perl(List/Util.pm)
BuildRequires: perl(MIME/Base64.pm)
BuildRequires: perl(Module/Build/Tiny.pm)
BuildRequires: perl(Module/Metadata.pm)
BuildRequires: perl(Moose.pm)
BuildRequires: perl(Net/SSLeay.pm)
BuildRequires: perl(Path/Tiny.pm)
BuildRequires: perl(Test/DZil.pm)
BuildRequires: perl(Test/Deep.pm)
BuildRequires: perl(Test/Deep/JSON.pm)
BuildRequires: perl(Test/Fatal.pm)
BuildRequires: perl(Test/More.pm)
BuildRequires: perl(Try/Tiny.pm)
BuildRequires: perl(if.pm)
BuildRequires: perl(strict.pm)
BuildRequires: perl(warnings.pm)
BuildArch:  noarch
Source44: import.info

%description
The following is a list of Plugin in this distribution to help you
integrate GitHub and Dist::Zilla:

* * the Dist::Zilla::Plugin::GitHub::Create manpage Create GitHub repo on
  dzil new

* * the Dist::Zilla::Plugin::GitHub::Update manpage Update GitHub repo info
  on release

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%make_build

%check
%make_build test

%install
%makeinstall_std

%files
%doc CONTRIBUTING Changes INSTALL LICENSE META.json META.yml  README
%{perl_vendor_privlib}/*

%changelog
