# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Dist-Zilla-Plugin-GitObtain
%define upstream_version 0.06

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt3_11

Summary:    Obtain files from a git repository before building a distribution
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/Dist/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(Dist/Zilla/Role/BeforeBuild.pm)
BuildRequires: perl(Dist/Zilla/Role/Plugin.pm)
BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(File/Path.pm)
BuildRequires: perl(File/Spec/Functions.pm)
BuildRequires: perl(Git/Wrapper.pm)
BuildRequires: perl(Moose.pm)
BuildRequires: perl(Test/More.pm)
BuildRequires: perl(namespace/autoclean.pm)
BuildArch:  noarch
Source44: import.info

%description
This module uses the Git::Wrapper manpage to obtain files from git
repositories before building a distribution.

You may specify the directory that git repositories will be placed into by
following the plugin name ('GitObtain') with a forward slash ('/'), then
the path to the particular directory. For instance, if your _dist.ini_ file
contained the following section:

  [GitObtain/alpha/beta/gamma]
    ...

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%make_build

%check
%make_build test

%install
%makeinstall_std

%files
%doc LICENSE META.yml  README
%perl_vendor_privlib/*

%changelog
