# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Dist-Zilla-Plugin-InsertCopyright
%define upstream_version 0.005

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt1_9

Summary:    Insert copyright statement into source code files
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/Dist/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(Carp.pm)
BuildRequires: perl(Dist/Zilla/Role/FileMunger.pm)
BuildRequires: perl(Dist/Zilla/Role/PPI.pm)
BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(File/Spec/Functions.pm)
BuildRequires: perl(File/pushd.pm)
BuildRequires: perl(List/Util.pm)
BuildRequires: perl(Moose.pm)
BuildRequires: perl(PPI/Document.pm)
BuildRequires: perl(Path/Tiny.pm)
BuildRequires: perl(Pod/Eventual.pm)
BuildRequires: perl(Test/DZil.pm)
BuildRequires: perl(Test/More.pm)
BuildRequires: perl(strict.pm)
BuildRequires: perl(utf8.pm)
BuildRequires: perl(version.pm)
BuildRequires: perl(warnings.pm)
BuildArch:  noarch
Source44: import.info

%description
This module replaces a special '# COPYRIGHT' comment in your Perl source
files with a short notice appropriate to your declared copyright. The
special comment *must* be placed before '__END__'. Only the first such
comment will be replaced.

It is inspired by excellent the Dist::Zilla::Plugin::Prepender manpage but
gives control of the copyright notice placement instead of always adding it
at the start of a file.

I wrote this to let me put copyright statements at the end of my code to
keep line numbers of code consistent between the generated distribution and
the repository source. See the Dist::Zilla::Plugin::OurPkgVersion manpage
for another useful plugin that preserves line numbering.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%make_build

%check
%make_build test

%install
%makeinstall_std

%files
%doc CONTRIBUTING Changes LICENSE META.json META.yml  README
%{perl_vendor_privlib}/*


%changelog
