%define module_name Dist-Zilla-Plugin-LocalHTML
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Cwd.pm) perl(Data/Dumper.pm) perl(Dist/Zilla/App.pm) perl(Dist/Zilla/File/InMemory.pm) perl(Dist/Zilla/Role/FileFinderUser.pm) perl(Dist/Zilla/Role/InstallTool.pm) perl(Encode.pm) perl(Encode/CN.pm) perl(Encode/JP.pm) perl(Encode/KR.pm) perl(Encode/TW.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Basename.pm) perl(File/Spec.pm) perl(Moose.pm) perl(Moose/Autobox.pm) perl(MooseX/NonMoose.pm) perl(PPI.pm) perl(Pod/Coverage/TrustPod.pm) perl(Pod/Find.pm) perl(Pod/Simple/HTML.pm) perl(Test/More.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(local/lib.pm) perl(namespace/autoclean.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.2.5
Release: alt1
Summary: Generate HTML documentation suitable for local browsing
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/V/VR/VRURG/%{module_name}-v%{version}.tar.gz
BuildArch: noarch

%description
*This plugin is based upon the Dist::Zilla::Plugin::Pod2Html manpage. Check for more
info below.*

This plugin generates HTML pages from the POD files and puts them into
the distribution in a separate directory (not as a tree of files but
flatten). The created HTML pages have the same (or, at least, similar)
style as the modules' documentation shown at CPAN. They're also suitable for
local browsing meaning linking between pages is local to the file system meaning
that pages are browsable without any webserver or posting a module to CPAN.
This could be especially handy for developers using unicode in their docs as
sometimes it is not displayed correctly with perldoc .e' like on macOS systems.

It creates HTML pages from all files in the `lib' and `bin'
directory that contain a POD section and that have `.pm' or `.pl'
extension or that have the word `perl' in their first line. The
plugin is run after other plugins that may munge files and create the
POD sections (such as *PodWeaver*).

The plugin overrides Pod::Simple::HTML link generation. By distinguishing local
and remote links it generates either a simple reference to local filesystem, or
a reference to metacpan.org. Link is conisdered local if there is a corresponding
file for the original `<'> Pod tag. For example, of the following to links:

    the Local::Project::Module manpage
    the Local::Project::NoModule manpage

the first one is considered local if there is file
lib/Local/Project/Module.pm; the second one would get linked to metacpan.org
if there is no file lib/Local/Project/NoModule.pm.

Link type could additionally be determined by the local_prefix entry elsewhere in this document configuration
variable.
%prep
%setup -q -n %{module_name}-v%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE Changelog README
%perl_vendor_privlib/D*

%changelog
