# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Dist-Zilla-Plugin-MetaData-BuiltWith
%define upstream_version 1.004005

%{?perl_default_filter}

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt1_5

Summary:    Go overkill and report everything in all name-spaces
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/Dist/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(CPAN/Meta/Converter.pm)
BuildRequires: perl(Carp.pm)
BuildRequires: perl(Devel/CheckBin.pm)
BuildRequires: perl(Dist/Zilla/File/FromCode.pm)
BuildRequires: perl(Dist/Zilla/Role/ConfigDumper.pm)
BuildRequires: perl(Dist/Zilla/Role/FileGatherer.pm)
BuildRequires: perl(Dist/Zilla/Role/FileMunger.pm)
BuildRequires: perl(Dist/Zilla/Role/MetaProvider.pm)
BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(File/Spec.pm)
BuildRequires: perl(JSON/MaybeXS.pm)
BuildRequires: perl(Module/Metadata.pm)
BuildRequires: perl(Module/Runtime.pm)
BuildRequires: perl(Moose.pm)
BuildRequires: perl(MooseX/Types/Moose.pm)
BuildRequires: perl(Path/Tiny.pm)
BuildRequires: perl(Test/DZil.pm)
BuildRequires: perl(Test/More.pm)
BuildRequires: perl(YAML/Tiny.pm)
BuildRequires: perl(constant.pm)
BuildRequires: perl(namespace/autoclean.pm)
BuildRequires: perl(strict.pm)
BuildRequires: perl(warnings.pm)
BuildArch:  noarch
Source44: import.info

%description
Often, distribution authors get module dependencies wrong. So in such
cases, its handy to be able to see what version of various packages they
built with.

Some would prefer to demand everyone install the same version as they did,
but that's also not always necessary.

Hopefully, the existence of the metadata provided by this module will help
users on their end machines make intelligent choices about what modules to
install in the event of a problem.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%make_build

%check
%make_build test

%install
%makeinstall_std

%files
%doc Changes LICENSE META.json META.yml  README
%{perl_vendor_privlib}/*

%changelog
