# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Module/Build/Tiny.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Dist-Zilla-Plugin-MinimumPerl
%define upstream_version 1.006

%{?perl_default_filter}

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt1_6

Summary:    Detects the minimum version of Perl required for your dist
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/Dist/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(Dist/Zilla/Role/FileFinderUser.pm)
BuildRequires: perl(Dist/Zilla/Role/PrereqSource.pm)
BuildRequires: perl(File/Find.pm)
BuildRequires: perl(File/Temp.pm)
BuildRequires: perl(Module/Build.pm)
BuildRequires: perl(Moose.pm)
BuildRequires: perl(Moose/Util/TypeConstraints.pm)
BuildRequires: perl(MooseX/Types/Perl.pm)
BuildRequires: perl(Perl/MinimumVersion.pm)
BuildRequires: perl(Test/More.pm)
BuildArch:  noarch
Source44: import.info

%description
This plugin uses the Perl::MinimumVersion manpage to automatically find the
minimum version of Perl required for your dist and adds it to the prereqs.
You can specify a version of Perl to override the scanning logic.

	# In your dist.ini:
	[MinimumPerl]

This plugin accepts the following options:

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%make_build

%check
%make_build test

%install
%makeinstall_std

%files
%doc Changes INSTALL LICENSE META.json META.yml README SIGNATURE examples
%perl_vendor_privlib/*

%changelog
