# BEGIN SourceDeps(oneline):
BuildRequires: perl(Data/Dmp.pm) perl(Data/Sah.pm) perl(Digest/SHA.pm) perl(Dist/Zilla/File/InMemory.pm) perl(Dist/Zilla/Role/FileFinderUser.pm) perl(Dist/Zilla/Role/FileGatherer.pm) perl(Dist/Zilla/Role/FileMunger.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Moose.pm) perl(PMVersions/Util.pm) perl(Pod/Coverage/TrustPod.pm) perl(Test/More.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(namespace/autoclean.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define module_name Dist-Zilla-Plugin-Rinci-GenSchemaV
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.000
Release: alt1
Summary: Generate Sah::SchemaV::* modules for all modules that contain Rinci function metadata
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/Dist-Zilla-Plugin-Rinci-GenSchemaV

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PE/PERLANCAR/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This plugin will generate a corresponding `Sah::SchemaV::*' modules for all
modules that contain Rinci function metadata. For example, if lib/My/Lib.pm
contains:

 package My::Lib;

 our %%SPEC;

 $SPEC{func1} = {
     v => 1.1,
     summary => 'Blah blah',
     args => {
         arg1 => {
             summary => 'Blah blah',
             schema => ['str*', len_between=>[1, 10]],
         },
         arg2 => {
             summary => 'Blah blah',
             schema => ['str*', len_between=>[1, 10]],
         },
         arg3 => {
             summary => 'Blah blah',
             schema => 'uint*',
         },
     },
 };
 sub func1 {
    ...
 }

 1;

then this plugin will generate lib/Sah/SchemaV/My/Lib.pm with the contents
like the following:

 package Sah::SchemaV::My::Lib;

 our %%Validators;
 our %%Args_Validators;

 # for ["str*","len_between",[1,10]]
 $Validators{'12bb9471cf257c92a9028dcd9bfa2078c186fd32'} = sub {
     ... validator code ...
 };
 # for "uint*"
 $Validators{'3668dd65767787facd64512dd40026ab6f7090d9'} = sub {
     ... validator code ...
 };

 $Args_Validators{func1} = {
    arg1 => $Validators{'12bb9471cf257c92a9028dcd9bfa2078c186fd32'},
    arg2 => $Validators{'12bb9471cf257c92a9028dcd9bfa2078c186fd32'},
 };

=for Pod::Coverage .+

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes LICENSE
%perl_vendor_privlib/D*

%changelog
