# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Module/Build.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Dist-Zilla-Plugin-Test-Compile
%define upstream_version 2.058

%{?perl_default_filter}

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt1_4

Summary:    Common tests to check syntax of your modules
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/Dist/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(CPAN/Meta/Check.pm)
BuildRequires: perl(CPAN/Meta/Requirements.pm)
BuildRequires: perl(Data/Section.pm)
BuildRequires: perl(Dist/Zilla.pm)
BuildRequires: perl(Dist/Zilla/Dist/Builder.pm)
BuildRequires: perl(Dist/Zilla/File/InMemory.pm)
BuildRequires: perl(Dist/Zilla/Role/FileFinderUser.pm)
BuildRequires: perl(Dist/Zilla/Role/FileGatherer.pm)
BuildRequires: perl(Dist/Zilla/Role/FileMunger.pm)
BuildRequires: perl(Dist/Zilla/Role/PrereqSource.pm)
BuildRequires: perl(Dist/Zilla/Role/TextTemplate.pm)
BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(File/Spec.pm)
BuildRequires: perl(File/pushd.pm)
BuildRequires: perl(IO/Handle.pm)
BuildRequires: perl(IPC/Open3.pm)
BuildRequires: perl(Module/Build/Tiny.pm)
BuildRequires: perl(Module/CoreList.pm)
BuildRequires: perl(Module/Metadata.pm)
BuildRequires: perl(Moose.pm)
BuildRequires: perl(Moose/Util/TypeConstraints.pm)
BuildRequires: perl(Path/Tiny.pm)
BuildRequires: perl(Perl/PrereqScanner.pm)
BuildRequires: perl(Sub/Exporter/ForMethods.pm)
BuildRequires: perl(Test/DZil.pm)
BuildRequires: perl(Test/Deep.pm)
BuildRequires: perl(Test/MinimumVersion.pm)
BuildRequires: perl(Test/More.pm)
BuildRequires: perl(Test/Warnings.pm)
BuildRequires: perl(if.pm)
BuildRequires: perl(namespace/autoclean.pm)
BuildRequires: perl(strict.pm)
BuildRequires: perl(utf8.pm)
BuildRequires: perl(version.pm)
BuildRequires: perl(warnings.pm)
BuildArch:  noarch
Source44: import.info

%description
This is an extension of the Dist::Zilla::Plugin::InlineFiles manpage,
providing the following files:

* t/00-compile.t - a standard test to check syntax of bundled modules

This test will find all modules and scripts in your dist, and try to
compile them one by one. This means it's a bit slower than loading them all
at once, but it will catch more errors.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor
%make_build

%check
%make_build test

%install
%makeinstall_std

%files
%doc CONTRIBUTING Changes INSTALL LICENCE META.json META.yml  README examples
%{perl_vendor_privlib}/*

%changelog
