# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Dist/Zilla.pm) perl(Dist/Zilla/Plugin/Authority.pm) perl(Dist/Zilla/Plugin/AutoPrereqs.pm) perl(Dist/Zilla/Plugin/CheckChangeLog.pm) perl(Dist/Zilla/Plugin/CheckChangesHasContent.pm) perl(Dist/Zilla/Plugin/CheckExtraTests.pm) perl(Dist/Zilla/Plugin/CheckPrereqsIndexed.pm) perl(Dist/Zilla/Plugin/CheckVersionIncrement.pm) perl(Dist/Zilla/Plugin/ConfirmRelease.pm) perl(Dist/Zilla/Plugin/EOLTests.pm) perl(Dist/Zilla/Plugin/GithubMeta.pm) perl(Dist/Zilla/Plugin/HasVersionTests.pm) perl(Dist/Zilla/Plugin/InstallGuide.pm) perl(Dist/Zilla/Plugin/InstallRelease.pm) perl(Dist/Zilla/Plugin/MetaJSON.pm) perl(Dist/Zilla/Plugin/MetaProvides/Class.pm) perl(Dist/Zilla/Plugin/MetaProvides/Package.pm) perl(Dist/Zilla/Plugin/MetaTests.pm) perl(Dist/Zilla/Plugin/MetaYAML.pm) perl(Dist/Zilla/Plugin/MinimumPerl.pm) perl(Data/Perl/Role/String.pm)
BuildRequires: perl(Dist/Zilla/Plugin/ModuleBuild.pm) perl(Dist/Zilla/Plugin/NextRelease.pm) perl(Dist/Zilla/Plugin/NoTabsTests.pm) perl(Dist/Zilla/Plugin/PkgVersion.pm) perl(Dist/Zilla/Plugin/PodCoverageTests.pm) perl(Dist/Zilla/Plugin/PodSyntaxTests.pm) perl(Dist/Zilla/Plugin/PodWeaver.pm) perl(Dist/Zilla/Plugin/ReadmeFromPod.pm) perl(Dist/Zilla/Plugin/ReportPhase.pm) perl(Dist/Zilla/Plugin/ReportVersions.pm) perl(Dist/Zilla/Plugin/Run/Release.pm) perl(Dist/Zilla/Plugin/RunExtraTests.pm) perl(Dist/Zilla/Plugin/SchwartzRatio.pm) perl(Dist/Zilla/Plugin/ShareDir/Tarball.pm) perl(Dist/Zilla/Plugin/SpellingCommonMistakesTests.pm) perl(Dist/Zilla/Plugin/TaskWeaver.pm) perl(Dist/Zilla/Plugin/Test/CPAN/Changes.pm) perl(Dist/Zilla/Plugin/Test/ChangesHasContent.pm) perl(Dist/Zilla/Plugin/Test/CheckDeps.pm) perl(Dist/Zilla/Plugin/Test/CheckManifest.pm)
BuildRequires: perl(Dist/Zilla/Plugin/Test/Compile.pm) perl(Dist/Zilla/Plugin/Test/Legal.pm) perl(Dist/Zilla/Plugin/Test/MinimumVersion.pm) perl(Dist/Zilla/Plugin/Test/Perl/Critic.pm) perl(Dist/Zilla/Plugin/Test/Portability.pm) perl(Dist/Zilla/Plugin/Test/ReportPrereqs.pm) perl(Dist/Zilla/Plugin/Test/UseAllModules.pm) perl(Dist/Zilla/Plugin/TestRelease.pm) perl(Dist/Zilla/PluginBundle/Git.pm) perl(Dist/Zilla/Role/PluginBundle/Merged.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec/Functions.pm) perl(List/Util.pm) perl(Module/Build.pm) perl(MooseX/Declare.pm) perl(Pod/Weaver/Plugin/WikiDoc.pm) perl(Pod/Weaver/Section/Support.pm) perl(Scalar/Util.pm) perl(Test/CPAN/Meta.pm) perl(Test/CheckDeps.pm) perl(Test/More.pm) perl(Test/UseAllModules.pm) perl(strict.pm) perl(true.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define module_version 1.2.5
%define module_name Dist-Zilla-PluginBundle-Author-DBR
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.2.5
Release: alt1
Summary: DBRs Dist::Zilla PluginBundle
Group: Development/Perl
License: perl
URL: https://github.com/xdbr/Dist-Zilla-PluginBundle-Author-DBR

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/D/DB/DBR/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
This PluginBundle is roughly equivalent to the following `dist.ini':

    # dist.ini
    [@Filter]
    -bundle          = @Classic
    -remove          = ExtraTests
    -remove          = PodVersion

    [Authority]
    authority        = cpan:DBR

    [AutoMetaResources]
    homepage            = https://metacpan.org/module/%%{dist}
    repository.type     = git
    repository.url      = git://github.com/xdbr/%%{dist}.git
    repository.web      = http://github.com/xdbr/%%{dist}
    bugtracker.web      = http://github.com/xdbr/%%{dist}/issues

    GithubMeta

    [@Git]
    changelog        = Changes             ; this is the default
    allow_dirty      = dist.ini            ; see Git::Check...
    allow_dirty      = Changes             ; ... and Git::Commit
    commit_msg       = v%%v%%n%%n%%c           ; see Git::Commit
    tag_format       = %%v                  ; see Git::Tag
    tag_message      = %%v                  ; see Git::Tag
    push_to          = origin              ; see Git::Push

    [Test::Portability]
    test_vms_length  = 0
    test_ansi_chars  = 0
    test_one_dot     = 0

    [PruneCruft]
    except           = '.gitignore'

    [ExecDir]
    dir              = bin

    [InstallRelease]
    install_command  = cpanm .

    [AutoPrereqs]
    [CheckChangesHasContent]
    [CheckExtraTests]
    [CheckPrereqsIndexed]
    [CheckVersionIncrement]
    [ConfirmRelease]
    [EOLTests]
    [HasVersionTests]
    [InstallGuide]
    [MetaJSON]
    [MetaProvides::Class]
    [MetaTests]
    [ModuleBuild]
    [NextRelease]
    [NoTabsTests]
    [PodWeaver]
    [ReadmeFromPod]
    [ReportVersions]
    [RunExtraTests]
    [SchwartzRatio]
    [ShareDir::Tarball]
    [SpellingCommonMistakesTests]
    [Test::ChangesHasContent]
    [Test::CheckDeps]
    [Test::CheckManifest]
    [Test::MinimumVersion]
    [Test::ReportPrereqs]
    [Test::UseAllModules]
    [TestRelease]


    [Prereqs]
    Dist::Zilla                                       = 0
    Dist::Zilla::Plugin::Authority                    = 0
    Dist::Zill...
%prep
%setup -q -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE README README.md Changes
%perl_vendor_privlib/D*

%changelog
