%define _without_test 1
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Data/Perl/Role/String.pm) perl(Dist/Zilla.pm) perl(Dist/Zilla/Plugin/Authority.pm) perl(Dist/Zilla/Plugin/Bugtracker.pm) perl(Dist/Zilla/Plugin/BumpVersionAfterRelease.pm) perl(Dist/Zilla/Plugin/CPANFile.pm) perl(Dist/Zilla/Plugin/CheckChangesHasContent.pm) perl(Dist/Zilla/Plugin/CheckMetaResources.pm) perl(Dist/Zilla/Plugin/CheckPrereqsIndexed.pm) perl(Dist/Zilla/Plugin/CopyFilesFromBuild.pm) perl(Dist/Zilla/Plugin/Git/Contributors.pm) perl(Dist/Zilla/Plugin/Git/NextVersion.pm) perl(Dist/Zilla/Plugin/GitHub/UploadRelease.pm) perl(Dist/Zilla/Plugin/GithubMeta.pm) perl(Dist/Zilla/Plugin/InsertCopyright.pm) perl(Dist/Zilla/Plugin/InstallGuide.pm) perl(Dist/Zilla/Plugin/MetaNoIndex.pm) perl(Dist/Zilla/Plugin/MetaProvides/Package.pm) perl(Dist/Zilla/Plugin/MinimumPerl.pm) perl(Dist/Zilla/Plugin/PodWeaver.pm)
BuildRequires: perl(Dist/Zilla/Plugin/Prereqs/AuthorDeps.pm) perl(Dist/Zilla/Plugin/PromptIfStale.pm) perl(Dist/Zilla/Plugin/ReadmeFromPod.pm) perl(Dist/Zilla/Plugin/RewriteVersion.pm) perl(Dist/Zilla/Plugin/RunExtraTests.pm) perl(Dist/Zilla/Plugin/TaskWeaver.pm) perl(Dist/Zilla/Plugin/Test/Compile.pm) perl(Dist/Zilla/Plugin/Test/MinimumVersion.pm) perl(Dist/Zilla/Plugin/Test/Perl/Critic.pm) perl(Dist/Zilla/Plugin/Test/PodSpelling.pm) perl(Dist/Zilla/Plugin/Test/Portability.pm) perl(Dist/Zilla/Plugin/Test/ReportPrereqs.pm) perl(Dist/Zilla/Plugin/Test/Version.pm) perl(Dist/Zilla/Plugin/TravisCI/StatusBadge.pm) perl(Dist/Zilla/Plugin/TravisYML.pm) perl(Dist/Zilla/PluginBundle/Filter.pm) perl(Dist/Zilla/PluginBundle/Git.pm) perl(Dist/Zilla/Role/PluginBundle/Config/Slicer.pm) perl(Dist/Zilla/Role/PluginBundle/Easy.pm)
BuildRequires: perl(Dist/Zilla/Role/PluginBundle/PluginRemover.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(File/pushd.pm) perl(Moose.pm) perl(Path/Tiny.pm) perl(Pod/Elemental/PerlMunger.pm) perl(Pod/Elemental/Transformer/List.pm) perl(Pod/Markdown.pm) perl(Pod/Weaver.pm) perl(Pod/Weaver/Config/Assembler.pm) perl(Pod/Weaver/Plugin/WikiDoc.pm) perl(Pod/Weaver/Section/Contributors.pm) perl(Pod/Weaver/Section/Support.pm) perl(Pod/Wordlist.pm) perl(Test/DZil.pm) perl(Test/More.pm) perl(Test/Portability/Files.pm) perl(namespace/autoclean.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define module_name Dist-Zilla-PluginBundle-NGLENN
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.07
Release: alt1
Summary: Dist::Zilla plugin configuration for me
Group: Development/Perl
License: apache
URL: https://github.com/garfieldnate/Dist-Zilla-PluginBundle-NGLENN

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/N/NG/NGLENN/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This is a the Dist::Zilla manpage PluginBundle.  It is roughly equivalent to the
following dist.ini:

  ; version provider
  [RewriteVersion] ; also munges

  ; collect contributors list
  [Git::Contributors]

  ; choose files to include
  [Git::GatherDir]         ; everything from git ls-files
  exclude_filename = README.mkdn  ; skip this generated file
  exclude_filename = Makefile.PL  ; skip this generated file
  exclude_filename = cpanfile     ; skip this generated file

  [PruneCruft]        ; default stuff to skip
  [ManifestSkip]      ; if -f MANIFEST.SKIP, skip those, too

  ; file modifications
  [InsertCopyright    ; add copyright at "# COPYRIGHT"
  [PodWeaver]         ; generate Pod
  config_plugin = @NGLENN ; my own plugin allows Pod::WikiDoc
  replacer = replace_with_comment
  post_code_replacer = replace_with_nothing

  ; generated files
  [License]           ; boilerplate license
  [ReadmeFromPod]     ; from Pod (runs after PodWeaver)
  [InstallGuide]      ; installation guide
  [TravisYML]         ; Travis-CI configuration
  build_branch = master
  ; t tests
  [Test::ReportPrereqs]   ; show prereqs in automated test output

  ; xt tests
  [Test::MinimumVersion]  ; xt/release/minimum-version.t
  max_target_perl = 5.010 ; don't use syntax/features past 5.10
  [Test::PodSpelling] ; xt/author/pod-spell.t
  [Test::Perl::Critic]; xt/author/critic.t
  [MetaTests]         ; xt/release/meta-yaml.t
  [PodSyntaxTests]    ; xt/release/pod-syntax.t
  [PodCoverageTests]  ; xt/release/pod-coverage.t
  [Test::Portability] ; xt/release/portability.t (of file name)
  options = test_one_dot = 0
  [Test::Version]     ; xt/release/test-version.t
  [Test::Compile]     ; xt/author/00-compile.t
  fake_home = 1       ; fakes $ENV{HOME} just in case
  xt_mode = 1         ; make sure all files compile

  ; metadata
  [AutoPrereqs]       ; find prereqs from code
  skip = ^t::lib

  [Authority]
  authority = cpan:NGLENN
  do_munging = 0

  [MinimumPerl]   ; determine minimum perl version

  [MetaNoIndex]       ; sets ...

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE Todo README Changes
%perl_vendor_privlib/D*
%perl_vendor_privlib/P*

%changelog
