# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Path/Tiny.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Dist-Zilla-PluginBundle-TestingMania
%define upstream_version 0.25

%{?perl_default_filter}

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt1_6

Summary:    Test your dist with every testing plugin
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/Dist/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(Dist/Zilla/Plugin/MetaTests.pm)
BuildRequires: perl(Dist/Zilla/Plugin/MojibakeTests.pm)
BuildRequires: perl(Dist/Zilla/Plugin/NoTabsTests.pm)
BuildRequires: perl(Dist/Zilla/Plugin/PodCoverageTests.pm)
BuildRequires: perl(Dist/Zilla/Plugin/PodSyntaxTests.pm)
BuildRequires: perl(Dist/Zilla/Plugin/Test/CPAN/Changes.pm)
BuildRequires: perl(Dist/Zilla/Plugin/Test/CPAN/Meta/JSON.pm)
BuildRequires: perl(Dist/Zilla/Plugin/Test/Compile.pm)
BuildRequires: perl(Dist/Zilla/Plugin/Test/DistManifest.pm)
BuildRequires: perl(Dist/Zilla/Plugin/Test/EOL.pm)
BuildRequires: perl(Dist/Zilla/Plugin/Test/Kwalitee.pm)
BuildRequires: perl(Dist/Zilla/Plugin/Test/MinimumVersion.pm)
BuildRequires: perl(Dist/Zilla/Plugin/Test/Perl/Critic.pm)
BuildRequires: perl(Dist/Zilla/Plugin/Test/Pod/LinkCheck.pm)
BuildRequires: perl(Dist/Zilla/Plugin/Test/Portability.pm)
BuildRequires: perl(Dist/Zilla/Plugin/Test/Synopsis.pm)
BuildRequires: perl(Dist/Zilla/Plugin/Test/UnusedVars.pm)
BuildRequires: perl(Dist/Zilla/Plugin/Test/Version.pm)
BuildRequires: perl(Dist/Zilla/Role/PluginBundle/Easy.pm)
BuildRequires: perl(File/Find.pm)
BuildRequires: perl(File/Path.pm)
BuildRequires: perl(File/Temp.pm)
BuildRequires: perl(JSON/PP.pm)
BuildRequires: perl(List/MoreUtils.pm)
BuildRequires: perl(Module/Build.pm)
BuildRequires: perl(Moose.pm)
BuildRequires: perl(Moose/Autobox.pm)
BuildRequires: perl(Pod/Coverage/TrustPod.pm)
BuildRequires: perl(Test/CPAN/Meta.pm)
BuildRequires: perl(Test/DZil.pm)
BuildRequires: perl(Test/More.pm)
BuildRequires: perl(Test/Perl/Critic.pm)
BuildRequires: perl(Test/Version.pm)
BuildRequires: perl(autodie.pm)
BuildRequires: perl(namespace/autoclean.pm)
BuildRequires: perl(strict.pm)
BuildRequires: perl(warnings.pm)

BuildConflicts: cpanminus

BuildArch:  noarch
Source44: import.info

%description
This plugin bundle collects all the testing plugins for the Dist::Zilla
manpage which exist (and are not deprecated). This is for the most paranoid
people who want to test their dist seven ways to Sunday.

Simply add the following near the end of _dist.ini_:

    [@TestingMania]

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%make_build

%check
%make_build test

%install
%makeinstall_std

%files
%doc Changes LICENSE META.json META.yml  README.mkdn
%{perl_vendor_privlib}/*


%changelog
