%define module_name Dist-Zilla-Role-RequireFromBuild
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Moose/Role.pm) perl(Pod/Coverage/TrustPod.pm) perl(Test/More.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.007
Release: alt1
Summary: Role to require() from build files
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/Dist-Zilla-Role-RequireFromBuild

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PE/PERLANCAR/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Since build files are not necessarily on-disk files, but might also be in-memory
files or files with munged content, we cannot use `require()' directly.
`require_from_build()' is like Perl's `require()' except it looks for files
not from `@INC' but from build files `$self->zilla->files'. It searches
libraries in `lib/' and `.'.

`$self->require_from_build("Foo/Bar.pm")' or `$self->require_from_build("Foo::Bar")' is a convenient shortcut for something
like:

 return if exists $INC{"Foo/Bar.pm"};

 my @files = grep { $_->name eq "lib/Foo/Bar.pm" } @{ $self->zilla->files };
 @files    = grep { $_->name eq "Foo/Bar.pm" }     @{ $self->zilla->files } unless @files;
 die "Can't find Foo/Bar.pm in lib/ or ./ in build files" unless @files;

 eval $files[0]->encoded_content;
 die if $@;

 $INC{"Foo/Bar.pm"} = "(set by Dist::Zilla::Role::RequireFromBuild, loaded from build file)";
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes LICENSE
%perl_vendor_privlib/D*

%changelog
