%define module_name Distribution-Guess-BuildSystem
# BEGIN SourceDeps(oneline):
BuildRequires: perl(CPAN.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec/Functions.pm) perl(Module/Build.pm) perl(Module/Extract/Use.pm) perl(Module/Extract/VERSION.pm) perl(Test/More.pm) perl(Test/Output.pm) perl(inc/Module/Install.pm) perl(version.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.007
Release: alt1
Summary: This is what the module does
Group: Development/Perl
License: artistic_2
URL: https://github.com/briandfoy/distribution-guess-buildsystem

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/B/BR/BRIANDFOY/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
There are three major build system for Perl distributions:.
=over 4

=item * ExtUtils::MakeMaker

Uses Makefile.PL and `make'.

=item * Module::Build

Uses Build.PL and `perl', although it might have a Makefile.PL that is
a wrapper.

=item * Module::Install

Uses Makefile.PL and calls to an embedded `Module::Install'. It might
use `auto_install' to call `CPAN.pm' at build time.

=back

The trick is to figure out which one you are supposed to use. This module has
several methods to look at a distribution and guess what its build system is.
The main object is simply some settings. Every time you want to ask a 
question about the distribution, the object looks at the distribution. That is,
it doesn't capture the information when you create the object. 


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.pod Changes SECURITY.md LICENSE examples
%perl_vendor_privlib/D*

%changelog
