%define module_name ELF-Writer
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Temp.pm) perl(FindBin.pm) perl(IO/File.pm) perl(Log/Any/Adapter.pm) perl(Log/Any/Adapter/TAP.pm) perl(Math/BigInt.pm) perl(Moo.pm) perl(Pod/Coverage/TrustPod.pm) perl(Test/More.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(namespace/clean.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.011
Release: alt1
Summary: Write ELF files using pure perl
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/N/NE/NERDVANA/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
my $elf= ELF::Writer::Linux_x86_64->new(
    type => 'executable',
    segments => [{
      virt_addr   => 0x10000,
      data        => $my_machine_code,
    }],
    entry_point => 0x10000,
  );
  $elf->write_file($binary_name);
  
  # Example above wastes almost 4K to align the first segment.
  # We can overlap the first segment with the elf header, so that the entire
  # file gets paged into RAM, but then the entry point needs adjusted by the
  # size of the ELF headers.
  
  my $prog_offset= $elf->elf_header_len + $elf->segment_header_elem_len;
  $elf->segments->[0]->offset(0);
  $elf->segments->[0]->data_start( $prog_offset );
  $elf->entry_point( $elf->segments->[0]->virt_addr + $prog_offset );
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md LICENSE README Changes
%perl_vendor_privlib/E*

%changelog
