%define module_version 3.04.8
%define module_name Email-IsEmail
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Scalar/Util.pm) perl(Test/More.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 3.04.8
Release: alt1
Summary: Checks an email address against the following RFCs: 3696, 1123, 4291, 5321, 5322
Group: Development/Perl
License: bsd
URL: https://metacpan.org/module/Email-IsEmail

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/L/LE/LEANDR/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
Checks an email address against the following RFCs: 3696, 1123, 4291, 5321, 5322

Example usage:

    use Email::IsEmail qw/IsEmail/;

    my $valid = Email::IsEmail('test@example.org');
    ...
    my $checkDNS = 0;
    my $error_level = -1;  # use dafault error threshold
    my %%parse_data = ();
    $valid = IsEmail( 'test@[127.0.0.1]', $checkDNS, $error_level \%%parse_data );
    print "Local-part: ", $parse_data{Email::IsEmail::COMPONENT_LOCALPART}, "\n";
    print "Domain: ", $parse_data{Email::IsEmail::COMPONENT_DOMAIN}, "\n";
%prep
%setup -q -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/E*

%changelog
