%define module_name Email-Send-SMTP-Gmail
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Authen/SASL.pm) perl(Email/Date/Format.pm) perl(Encode.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(LWP/MediaTypes.pm) perl(MIME/Base64.pm) perl(Net/SMTP.pm) perl(Net/SMTP_auth.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.35
Release: alt1
Summary: Sends emails with attachments supporting Auth over TLS or SSL (for example: Google's SMTP).
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PE/PECO/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Simple module to send emails through Google's SMTP with or without attachments. Also supports regular Servers (with plain or none auth).
Works with regular Gmail accounts as with Google Apps (your own domains).
It supports basic functions such as CC, BCC, ReplyTo.

=over

=item new(-login=>'', -pass=>'' [,-smtp=>'',layer=>'',-port=>'',-debug=>''])

It creates the object and opens a session with the SMTP.

=over

=item *smtp*: defines SMTP server. Default value: smtp.gmail.com

=item *layer*: defines the secure layer to use. It could be 'tls', 'ssl' or 'none'. Default value: tls

=item *port*: defines the port to use. Default values are 25 for tls and 465 for ssl

=item *auth*: defines the authentication method: ANONYMOUS, CRAM-MD5, DIGEST-MD5, EXTERNAL, GSSAPI, LOGIN (default) and PLAIN. It's currently based on SASL::Perl module

=item *debug*: see the log information

Also supports SSL parameters as:

=item *ssl_verify_mode*: SSL_VERIFY_NONE | SSL_VERIFY_PEER

=item *ssl_verify_path*: SSL_ca_path if SSL_VERIFY_PEER

=item *ssl_verify_file*: SSL_ca_file if SSL_VERIFY_PEER



=back

=item send(-from=>'', -to=>'', [-subject=>'', -cc=>'', -bcc=>'', -replyto=>'', -charset=>'', -body=>'', -attachments=>'', -verbose=>'1'])

It composes and sends the email in one shot

=over

=item *to, cc, bcc*: comma separated email addresses

=item *contenttype*: Content-Type for the body message. Examples are: text/plain (default), text/html, etc.

=item *attachments*: comma separated files with full path

=item *attachmentslist*: hashref $list, in format $list->[x]->{name} of files with full path. Example: $list->[0]->{file}='/full_path/file.pdf'


=back

=item bye

Closes the SMTP session

=back


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_privlib/E*

%changelog
