%define module_name Email-Store
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Class/DBI.pm) perl(Class/DBI/DATA/Schema.pm) perl(DBD/SQLite.pm) perl(DBD/mysql.pm) perl(Email/Address.pm) perl(Email/Date.pm) perl(Email/MIME.pm) perl(Email/MessageID.pm) perl(Email/Simple.pm) perl(Encode.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Slurp.pm) perl(MIME/Parser.pm) perl(MIME/Types.pm) perl(Mail/ListDetector.pm) perl(Module/Pluggable.pm) perl(Module/Pluggable/Ordered.pm) perl(SQL/Translator.pm) perl(Time/Piece.pm) perl(UNIVERSAL/require.pm) perl(base.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.257
Release: alt2
Summary: Framework for database-backed email storage
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/R/RJ/RJBS/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
`Email::Store' is the ideal basis for any application which needs to
deal with databases of email: archiving, searching, or even storing mail
for implementing IMAP or POP3 servers.

`Email::Store' itself is a very lightweight framework, meaning it does
not provide very much functionality itself; in effect, it is merely a
the Class::DBI manpage interface to a database schema which is designed for
storing email. Incidentally, if you don't know much about `Class::DBI',
you're going to need to in order to get much out of this.

Despite its minimalist nature, `Email::Store' is incredibly powerful.
Its power comes from its extensibility, through plugin modules and hooks
which allow you to add new database tables and concepts to the system,
and so access the mail store from a "different direction". In a sense,
`Email::Store' is a blank canvas, onto which you can pick and choose
(or even write!) the plugins which you want for your application.

For instance, the core `Email::Store::Entity' plugin module addresses
the idea of "people" in the email universe, allowing you to search for
mails to or from particular people; (despite their changing names or
email addresses) `Email::Store::Thread' interfaces `Email::Store' to
`Mail::Thread' allowing you to navigate mails by their position in a
mail thread; the planned non-core `Email::Store::Plucene' module plugs
into the indexing process and stores information about emails in a
Plucene search index for quick retrieval later, and so on.

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README LICENSE
%perl_vendor_privlib/E*

%changelog
