# BEGIN SourceDeps(oneline):
BuildRequires: perl(Config.pm) perl(Encode.pm) perl(Encode/CN.pm) perl(Encode/Encoding.pm) perl(Encode/JP.pm) perl(Encode/KR.pm) perl(ExtUtils/MakeMaker.pm) perl(Test/More.pm) perl(XSLoader.pm) perl(base.pm) perl-Encode-devel
# END SourceDeps(oneline)
%define module_version 0.04
%define module_name Encode-ISO2022
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.04
Release: alt7
Summary: ISO/IEC 2022 character encoding scheme
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/N/NE/NEZUMI/%module_name-%module_version.tar.gz

%description
This module provides a character encoding scheme (CES) switching a set of.multiple coded character sets (CCS).

A class method Define() may take following arguments.

=over 4

=item Alias => REGEX

The regular expression representing alias of this encoding, if any.

=item Name => STRING

The name of this encoding as the Encode::Encoding manpage object.
Mandatory.

=item CCS => [ FEATURE, FEATURE, ...]

List of features defining CCSs used by this encoding.
Mandatory.
Each item is a hash reference containing following items.

=over 4

=item bytes => NUMBER

Number of bytes to represent each character.
Default is 1.

=item cl => BOOLEAN

If true value is set, this CCS includes map to/from code points between
0/0 and 1/15.
There should be one CCS with this flag to reset broken designation.

=item dec_only => BOOLEAN

If true value is set, this CCS will be used only for decoding.

=item encoding => STRING | ENCODING

the Encode::Encoding manpage object used as CCS, or its name.
Mandatory.

Encodings used for CCS must provide "raw" conversion.
Namely, they must be stateless and fixed-length conversion over 94^n or 96^n
code tables.
the Encode::ISO2022::CCS manpage lists available CCSs.

=item g => STRING

=item g_init => STRING

Working set this CCS may be designated to:
`'g0'', `'g1'', `'g2'' or `'g3''.

If `g_init' is set, this CCS will be designated at beginning of coversion
implicitly, and at end of conversion explicitly.

If `g' or `g_init' is set and neither of `ls' nor `ss' is set,
this CCS will be invoked when it is designated.

If neither of `g', `g_init', `ls' nor `ss' is set,
this CCS is invoked always.

=item g_seq => STRING

Escape sequence to designate this CCS, if it can be designated explicitly.

=item gr => BOOLEAN

If true value is set, this CCS will be invoked to GR using 7-bit conversion
table.

=item ls => STRING

=item ss => STRING

Escape sequence or control character to invoke this CCS,
if it should be invoked explicitly.

If `ls' is set, this CCS will be invoked by locking-shift.
If `ss' is set, this CCS will be invoked by single-shift.

=item range => STRING

Possible range of encoded bytes.  General value is
`'\x21-\x7E'', `'\x20-\x7F'', `'\xA1-\xFE'' or `'\xA0-\xFF''.
This is required for multibyte CCSs to detect broken multibyte sequences.

=back

=item LineInit => BOOLEAN

If it is true, designation and invokation states will be initialized at
beginning of lines.

=item SubChar => STRING

Unicode string to be used for substitution character.

=back

To know more about use of this module,
the source of the Encode::ISO2022JP2 manpage may be an example.


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README
%perl_vendor_archlib/E*
%perl_vendor_autolib/*

%changelog
