# BEGIN SourceDeps(oneline):
BuildRequires: perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(HTML/Entities.pm) perl(Params/Get.pm) perl(Term/ANSIColor.pm) perl(Test/DescribeMe.pm) perl(Test/Most.pm) perl(Test/Needs.pm)
# END SourceDeps(oneline)
%define module_name Encode-Wide
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.03
Release: alt1
Summary: Convert wide characters (Unicode) into HTML or XML-safe ASCII entities
Group: Development/Perl
License: open_source
URL: https://metacpan.org/pod/Encode::Wide

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/N/NH/NHORNE/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
Encode::Wide provides functions for converting wide (Unicode) characters into ASCII-safe
formats suitable for embedding in HTML or XML documents. It is especially useful
when dealing with text containing accented or typographic characters that need
to be safely represented in markup.

The module offers two exportable functions:

=over 4

=item * `wide_to_html(string =' $text)>

Converts Unicode characters in the input string to their named HTML entities if available,
or hexadecimal numeric entities otherwise. Common characters such as `a.`, `ao`, `&`, `<`, `>` are
converted to their standard HTML representations like `&eacute;`, `&agrave;`, `&amp;`, etc.

=item * `wide_to_xml(string =' $text)>

Converts all non-ASCII characters in the input string to hexadecimal numeric entities.
Unlike HTML, XML does not support many named entities, so this function ensures compliance
by using numeric representations such as `&#xE9;` for `a.`.

=back

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE Changes README.md
%perl_vendor_privlib/E*

%changelog
