# BEGIN SourceDeps(oneline):
BuildRequires: perl(Config.pm) perl(Errno.pm) perl(Module/Build/Tiny.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define module_name English-Control
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.002
Release: alt1
Summary: use names beginning with control for punctuation variables
Group: Development/Perl
License: gpl
URL: https://github.com/aaronpriven/English-Control-pm

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/A/AA/AARONRP/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module provides aliases for the built-in variables whose names no one
seems to like to read. Variables with side-effects which get triggered just by
accessing them (like $0) will still be affected.

Unlike the English module, the aliases created by this module begin
with a control character, and thus will be always found in package "main", in
the area reserved by perl for its own use. They don't clutter the namespace
used by your program's variables or by any other modules.

For those variables that have an awk version, both long and short English
alternatives are provided. For example,  the `$/' variable can be referred to
either ${^RS} or  ${^INPUT_RECORD_SEPARATOR} if you are using this module.

See the perlvar manpage for a complete list of these. Except for $MATCH, $PREMATCH, and
$POSTMATCH, all the multi-character names are used.

Since control-character variables are forced to be in package main, nothing is
imported into the caller's namespace, and the control-character aliases are
made immediately upon compilation of this module. There is no difference
between

   use English::Control;

and

   use English::Control ();


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md Changes LICENSE
%perl_vendor_privlib/E*

%changelog
