%define _without_test 1
%define module_version 1.01
%define module_name EnsEMBL-Web-Record
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.01
Release: alt1
Summary: A family of modules used for managing a user's
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/M/MJ/MJW/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
Many web sites now encourage users to register and login to access
    more advanced features, and to customise a site to their needs.

    The EnsEMBL::Web::Record group of Perl modules is design to manage
    any arbitrary type of user created data in an SQL database. This
    module follows the Active Record design pattern, in that each new
    instantiated Record object represents a single row of a database.
    That object can be manipulated programatically, and any changes made
    can be stored in the database with a single record->save function
    call.

    Because arbitrary Perl data structures can be stored in this
    manner, EnsEMBL::Web::Record allows user preferences to be easily
    saved, and allows developers to implement new featurs quickly.

    This module was first used (and has been abstracted from) the
    Ensembl genome browser (http://www.ensembl.org).

    New user data can be added to the database:

    use EnsEMBL::Web::Record;

    my $bookmark = EnsEMBL::Web::Record->new();
    $bookmark->url('http://www.ensembl.org');
    $bookmark->name('Ensembl');
    $bookmark->save;
    ...
 
    The Record can be associated with an user id:

    $record->user($id);

    The same record can also be removed:

    $bookmark->delete;

    EnsEMBL::Web::Record also provides a number of methods for getting
    collections of records from the database, using a field selector.
 
    EnsEMBL::Web::Record::find_bookmarks_by_user_id($id).


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/E*

%changelog
