Group: Development/Perl
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Pod/Coverage/TrustPod.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(Test/Signature.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-Env-C
Version:        0.15
Release:        alt7_26
Summary:        Get/set/unset environment variables on the C level
License:        GPL-1.0-or-later OR Artistic-1.0-Perl
URL:            https://metacpan.org/release/Env-C
Source0:        https://cpan.metacpan.org/authors/id/M/MS/MSCHOUT/Env-C-%{version}.tar.gz
# Obey to perl's PERL_USE_SAFE_PUTENV default
Patch1:         Env-C-0.14-Obey-to-perl-s-PERL_USE_SAFE_PUTENV-default.patch
# Disable unreliable t/leak.t instead. ppc64 usually fails.
# <https://github.com/mschout/env-c/issues/3>
Patch2:         Env-C-0.14-Skip-unreliable-t-leat.t-test.patch
BuildRequires:  findutils
BuildRequires:  gcc
BuildRequires:  perl-devel
BuildRequires:  rpm-build-perl
BuildRequires:  perl-devel
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(warnings.pm)
# Run-time
BuildRequires:  perl(DynaLoader.pm)
# Tests
BuildRequires:  perl(Test/More.pm)
Source44: import.info

%description
This module provides a Perl API for getenv(3), setenv(3) and unsetenv(3).
It also can return all the environ variables.

%prep
%setup -q -n Env-C-%{version}
%patch1  -p1
%patch2  -p1

%build
perl Makefile.PL INSTALLDIRS=vendor OPTIMIZE="$RPM_OPT_FLAGS" NO_PACKLIST=1
%make_build

%install
make pure_install DESTDIR=$RPM_BUILD_ROOT
find $RPM_BUILD_ROOT -type f -name '*.bs' -size 0 -delete
# %{_fixperms} $RPM_BUILD_ROOT/*

%check
make test

%files
%doc --no-dereference LICENSE
%doc Changes README
%{perl_vendor_archlib}/auto/*
%{perl_vendor_archlib}/Env*

%changelog
