%define module_name Error-Show
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(constant/more.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.4.0
Release: alt1
Summary: Show context around syntax errors and exceptions
Group: Development/Perl
License: mit
URL: https://github.com/drclaw1394/perl-error-show

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/D/DR/DRCLAW/%{module_name}-v%{version}.tar.gz
BuildArch: noarch

%description
From the command line this module transparently executes your syntactically
correct program. However in the case of syntax errors (or warnings if desired),
it extracts context (lines of code) surrounding them. The lines are prefixed
with numbers  and the nicely formatted context is dumped on STDERR for you to
see the error or your ways.

The resulting output is optionally filtered seamlessly through the splain
program (see the diagnostics manpage), giving more information on why the reported
syntax errors and warnings might have occurred. 

From withing a program at runtime, this module can be used to give the same
formatted code context around the source of an exception and iterate through
any associated stack frames if provided.

It supports perl string exceptions and warnings directly and also provides the
ability to integrate third party CPAN exception objects and traces with minimal
effort. Please see examples in this document or in examples directory of the
distribution showing use with the Mojo::Exception manpage, the Exception::Base manpage,
the Exception::Class::Base manpage, and the Class::Throwable manpage.


A handful of options are available for basic configuration of how many lines of
code to print before and after the error line, indenting of stack trace
context, etc.

No symbols are exported and as such they must be accesses via the package name.

%prep
%setup -q -n %{module_name}-v%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes LICENSE README.md examples
%perl_vendor_privlib/E*

%changelog
