%define module_name Eval-Reversible
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Data/Perl/Role/Collection/Array.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Moo.pm) perl(MooX/HandlesVia.pm) perl(Scalar/Util.pm) perl(Test/More.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(Test/Strict.pm) perl(Test/Version.pm) perl(Test2/Bundle/More.pm) perl(Test2/Tools/Exception.pm) perl(Types/Standard.pm) perl(namespace/clean.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.900.1
Release: alt1
Summary: Evals with undo stacks
Group: Development/Perl
License: artistic_2
URL: https://github.com/GrantStreetGroup/Eval-Reversible

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/G/GS/GSG/%{module_name}-v%{version}.tar.gz
BuildArch: noarch

%description
Run code and automatically reverse their side effects if the code fails.  This is done by
way of an undo stack.  By calling the add_undo entry elsewhere in this document right after a side effect, the effect is
undone on the event that the the run_reversibly entry elsewhere in this document sub dies.  For example:

    $reversible->run_reversibly(sub {
        print "hello\n";
        $reversible->add_undo(sub { print "goodbye\n" });
        die "uh oh\n" if $something_bad;
    });

This prints "hello" if `$something_bad' is false.  If it's true, then both "hello" and
"goodbye" are printed and the exception "uh oh" is rethrown.

Upon failure, any code refs provided by calling the add_undo entry elsewhere in this document are executed in reverse
order.  Conceptually, we're unwinding the stack of side effects that `$code' performed
up to the point of failure.

%prep
%setup -q -n %{module_name}-v%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc CHANGES CONTRIBUTING.md LICENSE README
%perl_vendor_privlib/E*

%changelog
