%define module_name EventStore-Tiny
Epoch: 2
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Class/Tiny.pm) perl(Clone.pm) perl(Data/Compare.pm) perl(Data/Dump.pm) perl(ExtUtils/MakeMaker.pm) perl(FindBin.pm) perl(IO/File.pm) perl(List/Util.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(Time/HiRes.pm) perl(UUID/Tiny.pm) perl(YAML/Syck.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.72
Release: alt1
Summary: A minimal event sourcing framework.
Group: Development/Perl
License: mit
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/M/ME/MEMOWE/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
A minimal event sourcing framework.

## Example

Prepare event types and their predefined state actions (by side-effect):

```perl
use EventStore::Tiny;

my $store = EventStore::Tiny->new;

$store->register_event(UserAdded => sub {
    my ($state, $data) = @_;

    # Use $data to inject the new user into the given $state
    $state->{users}{$data->{id}} = {

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README.md LICENSE.txt
%perl_vendor_privlib/E*

%changelog
