# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(File/Spec.pm) perl(IO/Handle.pm) perl(IPC/Open3.pm) perl(Pod/Coverage/TrustPod.pm) perl(Test/More.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm)
# END SourceDeps(oneline)
%define module_version 0.1.1
%define module_name Examples-Generator
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.1.1
Release: alt1
Summary: A specification/convention for modules that generate sample data
Group: Development/Perl
License: perl
URL: https://metacpan.org/release/Examples-Generator

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PE/PERLANCAR/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
This document describes a set of convention for modules that generate sample
data.

Such modules should be named `*::Examples', for example:
the PERLANCAR::Tree::Examples manpage, the PERLANCAR::HTML::Tree::Examples manpage.

There must be a function in the module called `gen_sample_data()'. This
function must have an accompanying the Rinci manpage metadata to describe it. This
function must have `result_naked' property set to true. This function may be
set as `immutable' (meaning always generates the same return value given the
same arguments) or not.

Data parameter argument. There may be zero or more arguments that regulate
the variation of the sample data produced, for example a module that generates a
sample person name might have arguments: `gender', `nationality'. These
arguments must be tagged with `data-parameter'. They must be of simple type and
have the allowed possible values defined either using the `in' schema clause,
or `min'/`max'/`xmin'/`xmax'. For example:

 $SPEC{gen_sample_data} = {
     v => 1.1,
     summary => 'Generate sample person name',
     args => {
         gender => {
             schema => ['str*', in => ['M', 'F']],
             tags => ['data-parameter'],
         },
         nationality => {
             schema => ['str*', in => ['id', 'my', 'sg', 'th', 'ph', 'bn']],
             tags => ['data-parameter'],
         },
     },
     result_naked => 1,
 };

These data parameter arguments may be required or not. If a data parameter
argument is not required, usually this means a random default will be chosen for
it when not specified.

The data parameter arguments are tagged so other tools, like a POD generator,
could generate an overview of sample data by permuting all the data parameter
arguments and showing what the sample data would look like.
%prep
%setup -q -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README LICENSE Changes
%perl_vendor_privlib/E*

%changelog
