%define module_name Excel-Template-XLSX
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Archive/Zip.pm) perl(CPAN/Uploader.pm) perl(Excel/Writer/XLSX.pm) perl(Graphics/ColorUtils.pm) perl(Module/Build.pm) perl(Scalar/Util.pm) perl(Template/Tiny.pm) perl(Test/CheckManifest.pm) perl(Test/Differences.pm) perl(Test/More.pm) perl(XML/Twig.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.1.3
Release: alt1
Summary: perl module %module_name
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/D/DC/DCLARKE/%{module_name}-v%{version}.tar.gz
BuildArch: noarch

%description
This module is a companion to
Excel::Writer::XLSX(EWX), or
if you prefer, a wrapper to that module.  It uses EWX as a base class.  It opens
an existing spreadsheet file (.xlsx format), and also creates a new EWX object.
As it parses the template file(s), it calls EWX methods to re-create the template
contents in the EWX object.

When parsing is complete, the workbook object is left open for the calling perl
script to add additional content.

The purpose of this module is to separate the roles of content/presentation vs
programming in an Excel document, in much the same way that HTML templating
engines work.  A user who is knowledgeable in Excel can create an Excel file for
use as a template, without requiring the skill set of Perl or
Excel::Writer::XLSX. Conversely, the Perl programmer who is creating dynamic
content does not need design skills to layout the presentation in the template.
%prep
%setup -q -n %{module_name}-v%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc ignore.txt Changes README
%perl_vendor_privlib/E*

%changelog
