# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Apache2/Const.pm) perl(Date/Manip.pm) perl(Encode.pm) perl(IO/Scalar.pm) perl(Pod/Usage.pm) perl(Test/Differences.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    Excel-Writer-XLSX
%define upstream_version 1.14

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt1_1

Summary:    Light weight re-implementation of XML::Writer
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        https://metacpan.org/release/%{upstream_name}
Source0:    https://cpan.metacpan.org/modules/by-module/Excel/%{upstream_name}-%{upstream_version}.tar.gz

BuildRequires: perl(Archive/Zip.pm)
BuildRequires: perl(ExtUtils/MakeMaker.pm)
BuildRequires: perl(File/Temp.pm)
BuildRequires: perl(IO/File.pm)
BuildArch:  noarch

%{?perl_default_filter}
Source44: import.info

%description
The 'Excel::Writer::XLSX' module can be used to create an Excel file in the
2007+ XLSX format.

The XLSX format is the Office Open XML (OOXML) format used by Excel 2007
and later.

Multiple worksheets can be added to a workbook and formatting can be
applied to cells. Text, numbers, and formulas can be written to the cells.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Makefile.PL INSTALLDIRS=vendor

%make_build

%check
make test

%install
%makeinstall_std

%files
%doc Changes META.json META.yml  README examples
%{_bindir}/*
%{_mandir}/man?/*
%{perl_vendor_privlib}/*

%changelog
