%define module_name Experian-IDAuth
# internet 
%define _without_test 1
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Carp.pm) perl(Digest/SHA.pm) perl(ExtUtils/MakeMaker.pm) perl(File/MimeInfo/Magic.pm) perl(File/Spec.pm) perl(IO/Handle.pm) perl(IO/Socket.pm) perl(IO/Socket/SSL.pm) perl(IPC/Open3.pm) perl(Locale/Country.pm) perl(Path/Tiny.pm) perl(SOAP/Lite.pm) perl(Syntax/Keyword/Try.pm) perl(Test/CheckDeps.pm) perl(Test/Exception.pm) perl(Test/MockModule.pm) perl(Test/More.pm) perl(Test/Most.pm) perl(Test/Warnings.pm) perl(WWW/Mechanize.pm) perl(XML/Simple.pm) perl(XML/Twig.pm) perl(XS/Parse/Keyword.pm) perl(strict.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 2.53
Release: alt1
Summary: Experian's ID Authenticate service
Group: Development/Perl
License: perl
URL: https://github.com/binary-com/perl-Experian-IDAuth

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/B/BI/BINARY/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module provides an interface to Experian's Identity Authenticate service. 
http://www.experian.co.uk/identity-and-fraud/products/authenticate.html

First create a subclass of this module to override the defaults method
with your own data.

    package My::Experian;
    use strict;
    use warnings;
    use base 'Experian::IDAuth';

    # if you're using a logger
    use Log::Log4perl;

    sub defaults {
        my $self = shift;

        return (
            $self->SUPER::defaults,
            logger        => Log::Log4perl::get_logger,
            username      => 'my_user',
            password      => 'my_pass',
            residence     => $residence,
            postcode      => $postcode || '',
            date_of_birth => $date_of_birth || '',
            first_name    => $first_name || '',
            last_name     => $last_name || '',
            phone         => $phone || '',
            email         => $email || '',
        );
    }

    1;

Then use this module.

    use My::Experian;

    # search_option can either be ProveID_KYC or CheckID
    my $prove_id = My::Experian->new(
        search_option => 'ProveID_KYC',
    );

    my $prove_id_result = $prove_id->get_result();

    if (!$prove_id->has_done_request) {
        # connection problems
        die;
    }

    if ($prove_id_result->{fully_authenticated}) {
        # client successfully authenticated
    }
    if ($prove_id_result->{age_verified}) {
        # client's age is verified
    }
    if ($prove_id_result->{deceased} || $prove_id_result->{fraud}) {
        # client flagged as deceased or fraud
    }

    # CheckID is a more simpler version and can be used if ProveID_KYC fails
    my $check_id = My::Experian->new(
        search_option => 'CheckID',
    );

    if (!$check_id->has_done_request) {
        # connection problems
        die;
    }

    if ($check_id->get_result()) {
        # client successfully authenticated
    }
%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc LICENSE README Changes
%perl_vendor_privlib/E*

%changelog
