%define module_version 0.18
%define module_name Exporter-Easy
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Benchmark.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Run.pm) perl(Test/More.pm) perl(base.pm) perl(lib.pm) perl(strict.pm) perl(vars.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.18
Release: alt1
Summary: Takes the drudgery out of Exporting symbols
Group: Development/Perl
License: perl
URL: https://github.com/neilb/Exporter-Easy

Source0: http://cpan.org.ua/authors/id/N/NE/NEILB/%{module_name}-%{module_version}.tar.gz
BuildArch: noarch

%description
Exporter::Easy makes using Exporter easy. In it's simplest case it allows
you to drop the boilerplate code that comes with using Exporter, so

  require Exporter;
  use base qw( Exporter );
  use vars qw( @EXPORT );
  @EXPORT = ( 'init' );

becomes

  use Exporter::Easy ( EXPORT => [ 'init' ] );

and more complicated situations where you use tags to build lists and more
tags become easy, like this

  use Exporter::Easy (
  	EXPORT => [qw( init :base )],
  	TAGS => [
  		base => [qw( open close )],
  		read => [qw( read sysread readline )],
  		write => [qw( print write writeline )],
  		misc => [qw( select flush )],
  		all => [qw( :base :read :write :misc)],
  		no_misc => [qw( :all !:misc )],
  	],
  	OK => [qw( some other stuff )],
  );

This will set `@EXPORT', `@EXPORT_OK', `@EXPORT_FAIL' and `%%EXPORT_TAGS'
in the current package, add Exporter to that package's `@ISA' and do a
`use vars' on all the variables mentioned. The rest is handled as normal by
Exporter.


%prep
%setup -q -n %{module_name}-%{module_version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README LICENSE TODO
%perl_vendor_privlib/E*

%changelog
