%define _without_test 1
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Attribute/Handlers.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(Test/More.pm) perl(base.pm)
# END SourceDeps(oneline)
%define module_version 1.10
%define module_name Exporter-Simple
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.10
Release: alt1
Summary: Easier set-up of module exports
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://cpan.org.ua/authors/id/M/MA/MARCEL/%module_name-%module_version.tar.gz
BuildArch: noarch

%description
This module, when subclassed by a package, allows that package to define
exports in a more concise way than using `Exporter'. Instead of having to
worry what goes in `@EXPORT', `@EXPORT_OK' and `%%EXPORT_TAGS', you can
use two attributes to define exporter behavior. This has two advantages:
It frees you from the implementation details of `Exporter', and it
keeps the export definitions where they belong, with the subroutines
and variables.

The attributes provided by this module are:

=over 4

=item `Exported'

Indicates that the associated subroutine or global variable should
be automatically exported. It will also go into the `:all' tag
(per the rules of `%%EXPORT_TAGS'), as well as any tags you specify
as options of this attribute.

For example, the following declaration

  sub hello : Exported(greet,uk)   { ... }

will cause `hello()' to be exported, but also be available in the
tags `:all', `:greet' and `:uk'.

=item `Exportable'

Is like `Exported', except that the associated subroutine or
global variable won't be automatically exported.  It will still
go to the `:all' tag in any case and all other tags specified as
attribute options.

=back


%prep
%setup -n %module_name-%module_version

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes
%perl_vendor_privlib/E*

%changelog
