%define module_name ExtUtils-CXX
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Canary/Stability.pm) perl(Config.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(common/sense.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.0
Release: alt1
Summary: support C++ XS files
Group: Development/Perl
License: see COPYING
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/M/ML/MLEHMANN/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This module enables XS extensions written in C++. It is meant to be useful
for the users and installers of c++ modules, rather than the authors, by
having a single central place where to patch things, rather than to have
to patch every single module that overrides CC manually. That is, in the
worst case, you need to patch this module for your environment before
being able to CPAN-install further C++ modules; commonly, only setting a
few ENV variables is enough; and in the best case, it just works out of
the box.

(Comments on what to do and suggestions on how to achieve these things
better are welcome).

At the moment, it works by changing the values in `%%Config::Config'
temporarily. It does the following things:

=over 4

=item 1. It tries to change `$Config{cc}' and `$Config{ld}' into a C++ compiler.

If the environment variable `$CXX' is set, then it's value will be used
to replace both (except if `$PERL_CXXLD' is set, then that will be used for
`$Config{ld}'.

(There is also a `$PERL_CXX' which takes precedence over `$CXX').

The important thing is that the chosen C++ compiler compiles files with
a .c ending as C++ - a generic compiler wrapper such as gcc that
detects the lafguage by the file extension will *not* work.

In the absence of these variables, it will do the following
transformations on what it guesses will be the compiler name:

   gcc   => g++
   clang => clang++
   xlc   => xlC
   cc    => g++
   c89   => g++

=back

=over 4


%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc COPYING Changes README
%perl_vendor_privlib/E*

%changelog
