%define module_name FFI-Platypus-Declare
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Config.pm) perl(ExtUtils/MakeMaker.pm) perl(FFI/Build/MM.pm) perl(FFI/CheckLib.pm) perl(FFI/Platypus.pm) perl(Test/More.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.34
Release: alt3
Summary: (discouraged) Declarative interface to FFI::Platypus
Group: Development/Perl
License: perl
URL: https://metacpan.org/pod/FFI::Platypus::Declare

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/P/PL/PLICEASE/%{module_name}-%{version}.tar.gz

%description
This module is officially discouraged.  The idea was to provide a
simpler declarative interface without the need of (directly) creating
an the FFI::Platypus manpage instance.  In practice it is almost as complicated
and makes it difficult to upgrade to the proper OO interface if the
need arises.  I have stopped using it mainly for this reason.  It will
remain as part of the Platypus core distribution to keep old code working,
but you are encouraged to write new code using the OO interface.
Alternatively, you can try the Perl 6 inspired the NativeCall manpage, which
provides most of the goals this module was intended for (that is
a simple interface at the cost of some power), without much of the
complexity.  The remainder of this document describes the interface.

This module provides a declarative interface to the FFI::Platypus manpage. It
provides a more concise interface at the cost of a little less power,
and a little more namespace pollution.

Any strings passed into the `use' line will be declared as types and
exported as constants into your namespace, so that you can use them
without quotation marks.

Aliases can be declared using a list reference:

 use FFI::Platypus [ 'int[48]' => 'my_integer_array' ];

Custom types can also be declared as a list reference (the type name
must include a ::):

 use FFI::Platypus [ '::StringPointer' => 'my_string_pointer' ];
 # short for FFI::Platypus::Type::StringPointer

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README Changes author.yml LICENSE
%perl_vendor_privlib/F*

%changelog
