%define module_name FIX-Lite
# BEGIN SourceDeps(oneline):
BuildRequires: perl(IO/Select.pm) perl(IO/Socket.pm) perl(Time/HiRes.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.08
Release: alt1
Summary: Simple FIX (Financial Information eXchange) protocol module
Group: Development/Perl
License: perl
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/T/TH/THEUS/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
use FIX::Lite;
  my $fix = FIX::Lite->new(
      Host         => 'somefixserver.com',
      Port         => 5201,
      Debug        => 0,
      Timeout      => 60
  ) or die "Cannot connect to server: $!";

  # Then we usually need to login

  $fix->logon( 
      SenderCompID => 'somevalue1',
      TargetCompID => 'somevalue2',
      TargetSubID  => 'somevalue3',
      Username     => 'somevalue4',
      Password     => 'somevalue5',
      Debug        => 0
  ); 

  # To check the login results we can use method loggedIn()

  die "Cannot logon: $!" unless $fix->loggedIn()

  # After logon we can make some market request

  $fix->request( 
      MsgType => 'MarketDataRequest',
      SubscriptionRequestType => 'SNAPSHOT_PLUS_UPDATES',
      MarketDepth => 1,
      MDUpdateType => 'INCREMENTAL_REFRESH',
      NoRelatedSym => {
         Instrument => {
            Symbol => [
               'EUR/USD',
               'GBP/CHF'
            ]
         },
      },
      NoMDEntryTypes => {
         MDEntryType => [
           'BID',
           'OFFER'
         ]
      },
      Debug => $debug
  ) or die "Cannot send request: $!";

  # We then use lastRequest() method to get the parsed answer

  if ( $fix->lastRequest('MsgType') eq "REJECT" ) {
      print "Request was rejected\n";
      print "Reason: ".$fix->lastRequest('SessionRejectReason')."\n";
      print "RefTag: ".FIX::Lite->getTagById($fix->lastRequest('RefTagID'))."\n"; 
  }

  # And yup, we can use FIX::Lite->getTagById() method to resolve tag codes into 
  # human-readable values
  # After sending some subscriptions we can relax and wait for the quotes

  $fix->listen( \&handler,
        HeartBtInt => 30,
        Debug => 0
  );

  # Every incoming message (except Heartbeats and TestRequests) will call some handler function,
  # we need to just pass its reference as an argument. As for the hearbeats then
  # module will send them every HeartBtInt seconds (default is 30). And also the module will automatically answer
  # the test requests

  # To explicitly close the connection we can use quit() method  

  $fix->quit();

  # And a simple example of the handler function:

  sub handler {
     my $resp = shift;
     print "Received message ".$resp->{MsgType}."\n";
     if ( $resp->{MsgType} eq 'W' ) {
        print "Received Price ".$resp->{MDEntryPx}." for symbol ".$resp->{Symbol}."\n";
     }
     return 1;
  }
%prep
%setup -q -n %{module_name}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md README Changes
%perl_vendor_privlib/F*

%changelog
