# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(Digest/SHA.pm) perl(Test/Kwalitee.pm) perl(Test/More.pm) perl(Test/YAML/Meta.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
%define upstream_name    File-DataClass
%define upstream_version 0.73.1

%{?perl_default_filter}

Name:       perl-%{upstream_name}
Version:    %{upstream_version}
Release:    alt1_4

Summary:    Structured data file IO with OO paradigm
License:    GPL+ or Artistic
Group:      Development/Perl
Url:        http://search.cpan.org/dist/%{upstream_name}
Source0:    http://www.cpan.org/modules/by-module/File/%{upstream_name}-%{upstream_version}.tar.gz

BuildConflicts: cpanminus

BuildRequires: perl(Cache/FastMmap.pm)
BuildRequires: perl(Capture/Tiny.pm)
BuildRequires: perl(Class/Null.pm)
BuildRequires: perl(File/Path.pm)
BuildRequires: perl(File/ReadBackwards.pm)
BuildRequires: perl(File/Spec.pm)
BuildRequires: perl(File/pushd.pm)
BuildRequires: perl(Hash/Merge.pm)
BuildRequires: perl(JSON/MaybeXS.pm)
BuildRequires: perl(Module/Build.pm)
BuildRequires: perl(Module/Metadata.pm)
BuildRequires: perl(Module/Pluggable.pm)
BuildRequires: perl(Module/Runtime.pm)
BuildRequires: perl(Moo.pm)
BuildRequires: perl(Path/Tiny.pm)
BuildRequires: perl(Sub/Install.pm)
BuildRequires: perl(Subclass/Of.pm)
BuildRequires: perl(Sys/Hostname.pm)
BuildRequires: perl(Test/Deep.pm)
BuildRequires: perl(Test/Requires.pm)
BuildRequires: perl(Text/Diff.pm)
BuildRequires: perl(Try/Tiny.pm)
BuildRequires: perl(Type/Tiny.pm)
BuildRequires: perl(Unexpected.pm)
BuildRequires: perl(boolean.pm)
BuildRequires: perl(namespace/autoclean.pm)
BuildRequires: perl(namespace/clean.pm)
BuildRequires: perl(version.pm)
BuildArch:  noarch
Source44: import.info

%description
Provides methods for manipulating structured data stored in files of
different formats.

The documentation for this distribution starts in the class
File::DataClass::Schema.

%prep
%setup -q -n %{upstream_name}-%{upstream_version}

%build
/usr/bin/perl Build.PL --installdirs=vendor

./Build

%check
./Build test

%install
./Build install --destdir=%{buildroot}

%files
%doc Changes LICENSE META.json META.yml  README SIGNATURE
%{perl_vendor_privlib}/*

%changelog
