Group: Development/Perl
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl-podlators
# END SourceDeps(oneline)
# fedora bcond_with macro
%define bcond_with() %{expand:%%{?_with_%{1}:%%global with_%{1} 1}}
%define bcond_without() %{expand:%%{!?_without_%{1}:%%global with_%{1} 1}}
# redefine altlinux specific with and without
%define with()         %{expand:%%{?with_%{1}:1}%%{!?with_%{1}:0}}
%define without()      %{expand:%%{?with_%{1}:0}%%{!?with_%{1}:1}}
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
# Do not tests because they need a file system that has enabled extended
# attributes
%bcond_with perl_File_ExtAttr_enables_test

Name:           perl-File-ExtAttr
Version:        1.09
Release:        alt13_52
Summary:        Perl extension for accessing extended attributes of files
License:        GPL-1.0-or-later OR Artistic-1.0-Perl
URL:            https://metacpan.org/release/File-ExtAttr
Source0:        https://cpan.metacpan.org/authors/id/R/RI/RICHDAWE/File-ExtAttr-%{version}.tar.gz
# 1/2 Do not use attr library because attr-2.4.48 removed the header files in
# favour of glibc, CPAN RT#125804.
Patch0:         File-ExtAttr-1.09-Port-Linux-to-sys-xattr.h.patch
# 2/2 Do not use attr library because attr-2.4.48 removed the header files in
# favour of glibc, CPAN RT#125804.
Patch1:         File-ExtAttr-1.09-Remove-dependency-on-attr-library-on-Linux.patch

BuildRequires:  findutils
BuildRequires:  gcc
BuildRequires:  perl-devel
BuildRequires:  rpm-build-perl
BuildRequires:  perl-devel
BuildRequires:  perl(Config.pm)
BuildRequires:  perl(Cwd.pm)
BuildRequires:  perl(Exporter.pm)
BuildRequires:  perl(ExtUtils/MakeMaker.pm)
BuildRequires:  perl(File/Spec.pm)
BuildRequires:  perl(File/Temp.pm)
BuildRequires:  perl(IO/File.pm)
BuildRequires:  perl(lib.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(vars.pm)
%if %{with perl_File_ExtAttr_enables_test}
# Run-time
BuildRequires:  perl(AutoLoader.pm)
BuildRequires:  perl(base.pm)
BuildRequires:  perl(Carp.pm)
BuildRequires:  perl(Scalar/Util.pm)
BuildRequires:  perl(Tie/Hash.pm)
BuildRequires:  perl(warnings.pm)
BuildRequires:  perl(XSLoader.pm)
# Tests
BuildRequires:  perl(Data/Dumper.pm)
BuildRequires:  perl(Errno.pm)
BuildRequires:  perl(File/Path.pm)
BuildRequires:  perl(File/Find/Rule.pm)
BuildRequires:  perl(Module/CoreList.pm)
BuildRequires:  perl(Test/Distribution.pm)
BuildRequires:  perl(Test/More.pm)
BuildRequires:  perl(Test/Pod/Coverage.pm)
%endif
Source44: import.info



%description
File::ExtAttr is a Perl module providing access to the extended
attributes of files.

%prep
%setup -q -n File-ExtAttr-%{version}
%patch0  -p1
%patch1  -p1

%build
perl Makefile.PL INSTALLDIRS=vendor optimize="%{optflags}" NO_PACKLIST=1
%make_build

%install
make pure_install DESTDIR=%{buildroot}
find %{buildroot} -type f -name '*.bs' -size 0 -delete
# %{_fixperms} %{buildroot}/*

%check
%if %{with perl_File_ExtAttr_enables_test}
# NOTE:  these are noisy; as near as I can tell this is expected
# NOTE2: if you're testing on a filesystem that does not support extended
#        attributes, in all likelyhood the tests will fail.  If anyone has 
#        a quick&easy non-priv'ed way to test for this, I'll be more than 
#        happy to include it.
# NOTE3: Tests disabled for now, pending a way to detect & disable on non-ea 
#        enabled filesystems
make test
%endif


%files
%doc Changes README TODO
%{perl_vendor_archlib}/auto/*
%{perl_vendor_archlib}/File*

%changelog
