%define module_name File-Globstar
# BEGIN SourceDeps(oneline):
BuildRequires: perl(Cwd.pm) perl(Exporter.pm) perl(ExtUtils/MakeMaker.pm) perl(File/Find.pm) perl(File/Glob.pm) perl(File/Path.pm) perl(File/Spec.pm) perl(File/Temp.pm) perl(Git.pm) perl(IO/Handle.pm) perl(Locale/TextDomain.pm) perl(Module/Build.pm) perl(Pod/Coverage/TrustPod.pm) perl(Scalar/Util.pm) perl(Test/CPAN/Changes.pm) perl(Test/More.pm) perl(Test/Perl/Critic.pm) perl(Test/Pod.pm) perl(Test/Pod/Coverage.pm) perl(base.pm) perl(constant.pm) perl(lib.pm) perl(strict.pm) perl(vars.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 1.1.0
Release: alt1
Summary: Perl Globstar (double asterisk globbing) and utils
Group: Development/Perl
License: artistic_2
URL: http://www.guido-flohr.net/globstar-for-perl/

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/G/GU/GUIDO/%{module_name}-v%{version}.tar.gz
BuildArch: noarch

%description
Shortcut: If you want to implement file inclusion or exclusion in the style
of .gitignore, have a look at 
the File::Globstar::ListMatch manpage.

Many globbing implementations have been recently extended to accept the
pattern ** in place of a path element.  The double asterisk matches
all files and directories in the current directory and all of its
descendants including the current directory itself (in other words: the
directory . is included in the match, the parent directory .. is
not).

The convention is especially popular
in the Node.js ecosystem and is also used by git
when evaluating ignore patterns (see https://git-scm.com/docs/gitignore).

%prep
%setup -q -n %{module_name}-v%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README.md LICENSE Changes README.pod
%perl_vendor_privlib/F*

%changelog
