# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(File/KeePass/Agent.pm) perl(File/KeePass/KDBX.pm) perl(File/Spec.pm) perl(FindBin.pm) perl(Module/Load.pm) perl(Test/More.pm) perl(namespace/clean.pm) perl(parent.pm) perl(strict.pm) perl(utf8.pm) perl(warnings.pm)
# END SourceDeps(oneline)
%define module_name File-KeePass-Agent-KDBX
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.902
Release: alt1
Summary: A KeePass 2 agent
Group: Development/Perl
License: perl
URL: https://github.com/chazmcgarvey/File-KeePass-Agent-KDBX

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/C/CC/CCM/%{module_name}-%{version}.tar.gz
BuildArch: noarch

%description
This is a thin subclass of the File::KeePass::Agent manpage that uses the newer the File::KDBX manpage parser. It is meant to be
a drop-in replacement. This module really doesn't do anything except provide a way to load a backend other
than the File::KeePass manpage. You could accomplish the same thing with File::KeePass::Agent directly in a hackier
way:

    use File::KeePass::Agent;
    use File::KeePass::KDBX;

    no warnings 'redefine';
    *File::KeePass::Agent::keepass_class = sub { 'File::KeePass::KDBX' };

Perhaps in the future File::KeePass::Agent will support this without monkey-patching. Until then, this
module allows setting the backend File::KeePass class in three ways (in decreasing precedence):

Pass as an attribute to the constructor:

    File::KeePass::Agent::KDBX->new(keepass_class => 'My::KeePass')->run;

as a package variable:

    $File::KeePass::Agent::KDBX::KEEPASS_CLASS = 'My::KeePass';
    File::KeePass::Agent::KDBX->new->run;

or from the environment:

    $ENV{PERL_FILE_KEEPASS_CLASS} = 'My::KeePass';
    File::KeePass::Agent::KDBX->new->run;

%package scripts
Summary: %module_name scripts
Group: Development/Perl
Requires: %name = %EVR

%description scripts
scripts for %module_name

%prep
%setup -q -n %{module_name}-%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc Changes README LICENSE
%perl_vendor_privlib/F*

%files scripts
%_bindir/*
%_man1dir/*

%changelog
