%define module_name File-Meta-Cache
# BEGIN SourceDeps(oneline):
BuildRequires: perl(ExtUtils/MakeMaker.pm) perl(Log/OK.pm) perl(Log/ger.pm) perl(Object/Pad.pm) perl(XS/Parse/Keyword.pm) perl(XS/Parse/Sublike.pm) perl(constant/more.pm) perl(experimental.pm)
# END SourceDeps(oneline)
%define _unpackaged_files_terminate_build 1
BuildRequires: rpm-build-perl perl-devel perl-podlators

Name: perl-%module_name
Version: 0.3.0
Release: alt1
Summary: Cache open file descriptors and stat meta data
Group: Development/Perl
License: mit
Url: %CPAN %module_name

Source0: http://mirror.yandex.ru/mirrors/cpan/authors/id/D/DR/DRCLAW/%{module_name}-v%{version}.tar.gz
BuildArch: noarch

%description
Implements a caching mechanism to reuse a open handle/descriptor and meta data
when 'opening' a file multiple times. 

This is especially useful in a programs such as web servers which typically
access the same static file multiple times in response to requests. Not having
to open the file repeatedly can significantly reduce processing time. It also
reduces the number of open file descriptors required, which allows more files
to be accessed without adjusting process/user resource limits. 

Files are 'opened' and 'closed' via the cache in order to track how many
references to an entry are active (not perl reference counting btw). When an
entry has no references, it is eligible to be removed by 'sweeping' the cache.
This should be done a regular interval to keep the meta data fresh, but long
enough to make the cache useful.  To make this module event system agnostic it
is up to the user to implement a timer that calls the `sweep' API.

Importantly, a entry only uses a single file descriptor per file. Multiple
users of the same entry must track their own file positions. When doing IO on
the file, appropriate calls to `seek' (or `pread'/`pwrite' via `IO::FD')
will need to be performed to set the position for correct IO operation.


Each cached entry contains a `user_' field, which allows the user to store
associated meta data with the entry. For example this could be used to store
pre rendered HTTP headers (content-type, content-length, etag, modification
headers, etc), which only need to be computed when the file was opened.
 

Note this module is tuned for performance rather than nice programming style.
Thus fields within a cache entry are accessible by their position in an array
instead of a nice hash name or accessor methods.  

%prep
%setup -q -n %{module_name}-v%{version}

%build
%perl_vendor_build

%install
%perl_vendor_install

%files
%doc README README.md LICENSE Changes
%perl_vendor_privlib/F*

%changelog
