Group: Development/Other
# BEGIN SourceDeps(oneline):
BuildRequires(pre): rpm-build-perl
BuildRequires: perl(CPAN.pm) perl(LWP/Simple.pm) perl(Module/Build.pm) perl(Net/FTP.pm) perl(YAML/Tiny.pm) perl-podlators
# END SourceDeps(oneline)
# see https://bugzilla.altlinux.org/show_bug.cgi?id=10382
%define _localstatedir %{_var}
Name:           perl-File-PathList
Version:        1.04
Release:        alt2_42
Summary:        Find a file within a set of paths (like @INC or Java classpaths)
# Automatically converted from old format: GPL+ or Artistic - review is highly recommended.
License:        GPL-1.0-or-later OR Artistic-1.0-Perl
URL:            https://metacpan.org/release/File-PathList
Source0:        https://cpan.metacpan.org/authors/id/A/AD/ADAMK/File-PathList-%{version}.tar.gz
BuildArch:      noarch
BuildRequires:  coreutils
BuildRequires:  findutils
BuildRequires:  perl-devel
BuildRequires:  rpm-build-perl
BuildRequires:  perl(inc/Module/Install.pm)
BuildRequires:  perl(Module/Install/Metadata.pm)
BuildRequires:  perl(Module/Install/WriteAll.pm)
BuildRequires:  sed
# Run-time:
BuildRequires:  perl(File/Spec.pm)
BuildRequires:  perl(File/Spec/Unix.pm)
BuildRequires:  perl(Params/Util.pm)
BuildRequires:  perl(strict.pm)
BuildRequires:  perl(vars.pm)
# Tests only:
BuildRequires:  perl(File/Spec/Functions.pm)
BuildRequires:  perl(Test/More.pm)
Requires:       perl(File/Spec.pm) >= 0.800
Requires:       perl(Params/Util.pm) >= 0.240

# Remove underspecified dependencies

Source44: import.info
%filter_from_requires /^perl(\(File.Spec\|Params.Util\).pm)/d

%description
Many systems that map generic relative paths to absolute paths do so with a
set of base paths. For example, perl itself when loading classes first turn
a "Class::Name" into a path like "Class/Name.pm", and then looks through each
element of @INC to find the actual file. To aid in portability, all relative
paths are provided as UNIX-style relative paths, and converted to the
localized version in the process of looking up the path.

%prep
%setup -q -n File-PathList-%{version}
# Remove bundled modules
rm -r ./inc
sed -i -e '/^inc\//d' MANIFEST

%build
perl Makefile.PL INSTALLDIRS=vendor
%make_build

%install
make pure_install DESTDIR=$RPM_BUILD_ROOT
find $RPM_BUILD_ROOT -type f -name .packlist -exec rm -f {} \;
# %{_fixperms} $RPM_BUILD_ROOT/*

%check
make test

%files
%doc --no-dereference LICENSE
%doc Changes README
%{perl_vendor_privlib}/*

%changelog
